/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.Iterator;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.Transformer;

public abstract class AbstractScriptTransformer
extends CompilationUnit.SourceUnitOperation
implements Transformer {
    public void register(CompilationUnit compilationUnit) {
        compilationUnit.addPhaseOperation((CompilationUnit.SourceUnitOperation)this, this.getPhase());
    }

    protected abstract int getPhase();

    protected boolean isMethodOnThis(MethodCallExpression call, String name) {
        boolean isTaskMethod = call.getMethod() instanceof ConstantExpression && call.getMethod().getText().equals(name);
        return isTaskMethod && this.targetIsThis(call);
    }

    protected boolean targetIsThis(MethodCallExpression call) {
        Expression target = call.getObjectExpression();
        return target instanceof VariableExpression && target.getText().equals("this");
    }

    protected void visitScriptCode(SourceUnit source, GroovyCodeVisitor transformer) {
        source.getAST().getStatementBlock().visit(transformer);
        Iterator i$ = source.getAST().getMethods().iterator();
        while (i$.hasNext()) {
            MethodNode method;
            MethodNode methodNode = method = (MethodNode)i$.next();
            methodNode.getCode().visit(transformer);
        }
    }

    protected ClassNode getScriptClass(SourceUnit source) {
        if (source.getAST().getStatementBlock().getStatements().isEmpty() && source.getAST().getMethods().isEmpty()) {
            return null;
        }
        return (ClassNode)source.getAST().getClasses().get(0);
    }

    protected void removeMethod(ClassNode declaringClass, MethodNode methodNode) {
        declaringClass.getMethods().remove(methodNode);
        declaringClass.getDeclaredMethods(methodNode.getName()).clear();
    }
}

