/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.GString;
import java.util.Map;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.artifacts.dependencies.DefaultClientModule;
import org.gradle.api.internal.artifacts.dsl.dependencies.IDependencyImplementationFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.MapModuleNotationParser;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.internal.artifacts.dsl.dependencies.ParsedModuleStringNotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientModuleFactory
implements IDependencyImplementationFactory {
    private final MapModuleNotationParser mapNotationParser;
    private final ClassGenerator classGenerator;

    public DefaultClientModuleFactory(ClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
        this.mapNotationParser = new MapModuleNotationParser(classGenerator);
    }

    @Override
    public <T extends Dependency> T createDependency(Class<T> type, Object notation) throws IllegalDependencyNotation {
        assert (notation != null);
        if (notation instanceof String || notation instanceof GString) {
            return (T)((Dependency)type.cast(this.createDependencyFromString(notation.toString())));
        }
        if (notation instanceof Map) {
            return (T)((Dependency)type.cast(this.mapNotationParser.createDependency(DefaultClientModule.class, notation)));
        }
        throw new IllegalDependencyNotation();
    }

    private DefaultClientModule createDependencyFromString(String notation) {
        ParsedModuleStringNotation parsedNotation = new ParsedModuleStringNotation(notation, null);
        DefaultClientModule clientModule = this.classGenerator.newInstance(DefaultClientModule.class, parsedNotation.getGroup(), parsedNotation.getName(), parsedNotation.getVersion());
        ModuleFactoryHelper.addExplicitArtifactsIfDefined(clientModule, null, parsedNotation.getClassifier());
        return clientModule;
    }
}

