/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.IDependencyImplementationFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryDelegate;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectDependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyFactory
implements DependencyFactory {
    private Set<IDependencyImplementationFactory> dependencyFactories;
    private IDependencyImplementationFactory clientModuleFactory;
    private ProjectDependencyFactory projectDependencyFactory;

    public DefaultDependencyFactory(Set<IDependencyImplementationFactory> dependencyFactories, IDependencyImplementationFactory clientModuleFactory, ProjectDependencyFactory projectDependencyFactory) {
        this.dependencyFactories = dependencyFactories;
        this.clientModuleFactory = clientModuleFactory;
        this.projectDependencyFactory = projectDependencyFactory;
    }

    @Override
    public Dependency createDependency(Object dependencyNotation) {
        if (dependencyNotation instanceof Dependency) {
            return (Dependency)dependencyNotation;
        }
        Dependency dependency = null;
        for (IDependencyImplementationFactory factory : this.dependencyFactories) {
            try {
                dependency = factory.createDependency(Dependency.class, dependencyNotation);
                break;
            }
            catch (IllegalDependencyNotation e) {
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not create a dependency using notation: %s", dependencyNotation), e);
            }
        }
        if (dependency == null) {
            throw new InvalidUserDataException(String.format("The dependency notation: %s is invalid.", dependencyNotation));
        }
        return dependency;
    }

    @Override
    public ClientModule createModule(Object dependencyNotation, Closure configureClosure) {
        ClientModule clientModule = this.clientModuleFactory.createDependency(ClientModule.class, dependencyNotation);
        ModuleFactoryDelegate moduleFactoryDelegate = new ModuleFactoryDelegate(clientModule, this);
        moduleFactoryDelegate.prepareDelegation(configureClosure);
        if (configureClosure != null) {
            configureClosure.call();
        }
        return clientModule;
    }

    @Override
    public ProjectDependency createProjectDependencyFromMap(ProjectFinder projectFinder, Map<? extends String, ? extends Object> map) {
        return this.projectDependencyFactory.createProjectDependencyFromMap(projectFinder, map);
    }
}

