/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.artifacts.ProjectDependenciesBuildInstruction;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectDependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDependencyFactory
implements ProjectDependencyFactory {
    private final ProjectDependenciesBuildInstruction instruction;
    private final ClassGenerator classGenerator;

    public DefaultProjectDependencyFactory(ProjectDependenciesBuildInstruction instruction, ClassGenerator classGenerator) {
        this.instruction = instruction;
        this.classGenerator = classGenerator;
    }

    @Override
    public <T extends Dependency> T createDependency(Class<T> type, Object userDependencyDescription) throws IllegalDependencyNotation {
        if (userDependencyDescription instanceof Project) {
            return (T)((Dependency)type.cast(this.classGenerator.newInstance(DefaultProjectDependency.class, userDependencyDescription, this.instruction)));
        }
        throw new IllegalDependencyNotation();
    }

    @Override
    public ProjectDependency createProjectDependencyFromMap(ProjectFinder projectFinder, Map<? extends String, ? extends Object> map) {
        HashMap<String, Object> args = new HashMap<String, Object>(map);
        String path = this.getAndRemove(args, "path");
        String configuration = this.getAndRemove(args, "configuration");
        ProjectDependency dependency = this.classGenerator.newInstance(DefaultProjectDependency.class, projectFinder.getProject(path), configuration, this.instruction);
        ConfigureUtil.configureByMap(args, dependency);
        return dependency;
    }

    private String getAndRemove(Map<String, Object> args, String key) {
        Object value = args.get(key);
        args.remove(key);
        return value != null ? value.toString() : null;
    }
}

