/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.GString;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.IDependencyImplementationFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.MapModuleNotationParser;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.internal.artifacts.dsl.dependencies.ParsedModuleStringNotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDependencyFactory
implements IDependencyImplementationFactory {
    private final MapModuleNotationParser mapNotationParser;
    private final ClassGenerator classGenerator;
    private static final Pattern EXTENSION_SPLITTER = Pattern.compile("^(.+)\\@([^:]+$)");

    public ModuleDependencyFactory(ClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
        this.mapNotationParser = new MapModuleNotationParser(classGenerator);
    }

    @Override
    public <T extends Dependency> T createDependency(Class<T> type, Object notation) throws IllegalDependencyNotation {
        assert (notation != null);
        if (notation instanceof String || notation instanceof GString) {
            return (T)((Dependency)type.cast(this.createDependencyFromString(notation.toString())));
        }
        if (notation instanceof Map) {
            return (T)((Dependency)type.cast(this.mapNotationParser.createDependency(DefaultExternalModuleDependency.class, notation)));
        }
        throw new IllegalDependencyNotation();
    }

    private DefaultExternalModuleDependency createDependencyFromString(String notation) {
        ParsedModuleStringNotation parsedNotation = this.splitDescriptionIntoModuleNotationAndArtifactType(notation);
        DefaultExternalModuleDependency moduleDependency = this.classGenerator.newInstance(DefaultExternalModuleDependency.class, parsedNotation.getGroup(), parsedNotation.getName(), parsedNotation.getVersion());
        ModuleFactoryHelper.addExplicitArtifactsIfDefined(moduleDependency, parsedNotation.getArtifactType(), parsedNotation.getClassifier());
        return moduleDependency;
    }

    private ParsedModuleStringNotation splitDescriptionIntoModuleNotationAndArtifactType(String notation) {
        Matcher matcher = EXTENSION_SPLITTER.matcher(notation);
        boolean hasArtifactType = matcher.matches();
        if (hasArtifactType) {
            if (matcher.groupCount() != 2) {
                throw new InvalidUserDataException("The description " + notation + " is invalid");
            }
            return new ParsedModuleStringNotation(matcher.group(1), matcher.group(2));
        }
        return new ParsedModuleStringNotation(notation, null);
    }
}

