/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import org.gradle.api.IllegalDependencyNotation;
import org.gradle.util.GUtil;

class ParsedModuleStringNotation {
    private String group;
    private String name;
    private String version;
    private String classifier;
    private String artifactType;

    ParsedModuleStringNotation(String moduleNotation, String artifactType) {
        this.assignValuesFromModuleNotation(moduleNotation);
        this.artifactType = artifactType;
    }

    private void assignValuesFromModuleNotation(String moduleNotation) {
        String[] moduleNotationParts = moduleNotation.split(":");
        if (moduleNotationParts.length < 2 || moduleNotationParts.length > 4) {
            throw new IllegalDependencyNotation("The description " + moduleNotation + " is invalid");
        }
        this.group = GUtil.elvis(moduleNotationParts[0], null);
        this.name = moduleNotationParts[1];
        String string = this.version = moduleNotationParts.length == 2 ? null : moduleNotationParts[2];
        if (moduleNotationParts.length == 4) {
            this.classifier = moduleNotationParts[3];
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getArtifactType() {
        return this.artifactType;
    }
}

