/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.CachingDirectedGraphWalker;
import org.gradle.api.internal.DirectedGraphWithEdgeValues;
import org.gradle.api.internal.artifacts.ivyservice.IvyConversionResult;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.IvyLoggingAdaper;
import org.gradle.api.internal.artifacts.ivyservice.IvyReportConverter;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.util.Clock;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIvyDependencyResolver
implements IvyDependencyResolver {
    private static Logger logger = LoggerFactory.getLogger(DefaultIvyDependencyResolver.class);
    private IvyReportConverter ivyReportTranslator;

    public DefaultIvyDependencyResolver(IvyReportConverter ivyReportTranslator) {
        this.ivyReportTranslator = ivyReportTranslator;
        Message.setDefaultLogger((MessageLogger)new IvyLoggingAdaper());
    }

    public ResolvedConfiguration resolve(Configuration configuration, Ivy ivy, ModuleDescriptor moduleDescriptor) {
        ResolveReport resolveReport;
        Clock clock = new Clock();
        ResolveOptions resolveOptions = this.createResolveOptions(configuration);
        try {
            resolveReport = ivy.resolve(moduleDescriptor, resolveOptions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.debug("Timing: Ivy resolve took {}", (Object)clock.getTime());
        return new ResolvedConfigurationImpl(resolveReport, configuration);
    }

    private ResolveOptions createResolveOptions(Configuration configuration) {
        ResolveOptions resolveOptions = new ResolveOptions();
        resolveOptions.setDownload(false);
        resolveOptions.setConfs(WrapUtil.toArray(configuration.getName()));
        return resolveOptions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResolvedConfigurationImpl
    implements ResolvedConfiguration {
        private final Configuration configuration;
        private boolean hasError;
        private List<String> problemMessages;
        private IvyConversionResult conversionResult;
        private final CachingDirectedGraphWalker<ResolvedDependency, ResolvedArtifact> walker = new CachingDirectedGraphWalker<ResolvedDependency, ResolvedArtifact>(new ResolvedDependencyArtifactsGraph());

        public ResolvedConfigurationImpl(ResolveReport resolveReport, Configuration configuration) {
            this.hasError = resolveReport.hasError();
            if (this.hasError) {
                this.problemMessages = resolveReport.getAllProblemMessages();
            } else {
                this.conversionResult = DefaultIvyDependencyResolver.this.ivyReportTranslator.convertReport(resolveReport, configuration);
            }
            this.configuration = configuration;
        }

        @Override
        public boolean hasError() {
            return this.hasError;
        }

        @Override
        public void rethrowFailure() throws ResolveException {
            if (this.hasError) {
                Formatter formatter = new Formatter();
                for (String msg : this.problemMessages) {
                    formatter.format("    - %s%n", msg);
                }
                throw new ResolveException(this.configuration, formatter.toString());
            }
        }

        @Override
        public Set<File> getFiles(Spec<Dependency> dependencySpec) {
            this.rethrowFailure();
            Set<ModuleDependency> allDependencies = this.configuration.getAllDependencies(ModuleDependency.class);
            Set<Dependency> selectedDependencies = Specs.filterIterable(allDependencies, dependencySpec);
            LinkedHashSet<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
            for (ModuleDependency moduleDependency : selectedDependencies) {
                Set<ResolvedDependency> resolvedDependencies = this.conversionResult.getFirstLevelResolvedDependencies().get(moduleDependency);
                for (ResolvedDependency resolvedDependency : resolvedDependencies) {
                    artifacts.addAll(resolvedDependency.getParentArtifacts(this.conversionResult.getRoot()));
                    this.walker.add((ResolvedDependency[])new ResolvedDependency[]{resolvedDependency});
                }
            }
            artifacts.addAll(this.walker.findValues());
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (ResolvedArtifact artifact : artifacts) {
                File depFile = artifact.getFile();
                if (depFile != null) {
                    files.add(depFile);
                    continue;
                }
                logger.debug(String.format("Resolved artifact %s contains a null value.", artifact));
            }
            return files;
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
            this.rethrowFailure();
            return this.conversionResult.getRoot().getChildren();
        }

        @Override
        public Set<ResolvedArtifact> getResolvedArtifacts() {
            this.rethrowFailure();
            return this.conversionResult.getResolvedArtifacts();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ResolvedDependencyArtifactsGraph
        implements DirectedGraphWithEdgeValues<ResolvedDependency, ResolvedArtifact> {
            private ResolvedDependencyArtifactsGraph() {
            }

            @Override
            public void getNodeValues(ResolvedDependency node, Collection<ResolvedArtifact> values, Collection<ResolvedDependency> connectedNodes) {
                values.addAll(node.getModuleArtifacts());
                connectedNodes.addAll(node.getChildren());
            }

            @Override
            public void getEdgeValues(ResolvedDependency from, ResolvedDependency to, Collection<ResolvedArtifact> values) {
                values.addAll(to.getParentArtifacts(from));
            }
        }
    }
}

