/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.IvyService;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlingIvyService
implements IvyService {
    private final IvyService ivyService;

    public ErrorHandlingIvyService(IvyService ivyService) {
        this.ivyService = ivyService;
    }

    public IvyService getIvyService() {
        return this.ivyService;
    }

    @Override
    public void publish(Set<Configuration> configurationsToPublish, File descriptorDestination, List<DependencyResolver> publishResolvers) {
        try {
            this.ivyService.publish(configurationsToPublish, descriptorDestination, publishResolvers);
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not publish configurations %s.", configurationsToPublish), e);
        }
    }

    @Override
    public ResolvedConfiguration resolve(Configuration configuration) {
        ResolvedConfiguration resolvedConfiguration;
        try {
            resolvedConfiguration = this.ivyService.resolve(configuration);
        }
        catch (Throwable e) {
            return new BrokenResolvedConfiguration(e, configuration);
        }
        return new ErrorHandlingResolvedConfiguration(resolvedConfiguration, configuration);
    }

    private static ResolveException wrapException(Throwable e, Configuration configuration) {
        if (e instanceof ResolveException) {
            return (ResolveException)e;
        }
        return new ResolveException(configuration, e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BrokenResolvedConfiguration
    implements ResolvedConfiguration {
        private final Throwable e;
        private final Configuration configuration;

        public BrokenResolvedConfiguration(Throwable e, Configuration configuration) {
            this.e = e;
            this.configuration = configuration;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public void rethrowFailure() throws ResolveException {
            throw ErrorHandlingIvyService.wrapException(this.e, this.configuration);
        }

        @Override
        public Set<File> getFiles(Spec<Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingIvyService.wrapException(this.e, this.configuration);
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            throw ErrorHandlingIvyService.wrapException(this.e, this.configuration);
        }

        @Override
        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            throw ErrorHandlingIvyService.wrapException(this.e, this.configuration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorHandlingResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolvedConfiguration resolvedConfiguration;
        private final Configuration configuration;

        public ErrorHandlingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, Configuration configuration) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.configuration = configuration;
        }

        @Override
        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        @Override
        public void rethrowFailure() throws ResolveException {
            try {
                this.resolvedConfiguration.rethrowFailure();
            }
            catch (Throwable e) {
                throw ErrorHandlingIvyService.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<File> getFiles(Spec<Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingIvyService.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingIvyService.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            try {
                return this.resolvedConfiguration.getResolvedArtifacts();
            }
            catch (Throwable e) {
                throw ErrorHandlingIvyService.wrapException(e, this.configuration);
            }
        }
    }
}

