/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.gradle.util.UncheckedException;

public class GradleIBiblioResolver
extends IBiblioResolver {
    public static final CacheTimeoutStrategy NEVER = new CacheTimeoutStrategy(){

        public boolean isCacheTimedOut(long lastResolvedTime) {
            return false;
        }
    };
    public static final CacheTimeoutStrategy ALWAYS = new CacheTimeoutStrategy(){

        public boolean isCacheTimedOut(long lastResolvedTime) {
            return true;
        }
    };
    public static final CacheTimeoutStrategy DAILY = new CacheTimeoutStrategy(){

        public boolean isCacheTimedOut(long lastResolvedTime) {
            Calendar calendarCurrent = Calendar.getInstance();
            calendarCurrent.setTime(new Date());
            int dayOfYear = calendarCurrent.get(6);
            int year = calendarCurrent.get(1);
            Calendar calendarLastResolved = Calendar.getInstance();
            calendarLastResolved.setTime(new Date(lastResolvedTime));
            return calendarLastResolved.get(1) != year || calendarLastResolved.get(6) != dayOfYear;
        }
    };
    private CacheTimeoutStrategy snapshotTimeout = DAILY;

    public CacheTimeoutStrategy getSnapshotTimeout() {
        return this.snapshotTimeout;
    }

    public void setSnapshotTimeout(long snapshotLifetime) {
        this.snapshotTimeout = new Interval(snapshotLifetime);
    }

    public void setSnapshotTimeout(CacheTimeoutStrategy cacheTimeoutStrategy) {
        this.snapshotTimeout = cacheTimeoutStrategy;
    }

    public void setRoot(String root) {
        URI rootUri;
        super.setRoot(root);
        try {
            rootUri = new URI(root);
        }
        catch (URISyntaxException e) {
            throw UncheckedException.asUncheckedException(e);
        }
        if (rootUri.getScheme().equalsIgnoreCase("file")) {
            this.setSnapshotTimeout(ALWAYS);
        } else {
            this.setSnapshotTimeout(DAILY);
        }
    }

    protected ResolvedModuleRevision findModuleInCache(DependencyDescriptor dd, ResolveData data) {
        this.setChangingPattern(null);
        ResolvedModuleRevision moduleRevision = super.findModuleInCache(dd, data);
        if (moduleRevision == null) {
            this.setChangingPattern(".*-SNAPSHOT");
            return null;
        }
        PropertiesFile cacheProperties = this.getCacheProperties(dd, moduleRevision);
        Long lastResolvedTime = this.getLastResolvedTime(cacheProperties);
        this.updateCachePropertiesToCurrentTime(cacheProperties);
        if (this.snapshotTimeout.isCacheTimedOut(lastResolvedTime)) {
            this.setChangingPattern(".*-SNAPSHOT");
            return null;
        }
        return moduleRevision;
    }

    private void updateCachePropertiesToCurrentTime(PropertiesFile cacheProperties) {
        cacheProperties.setProperty("resolved.time", "" + System.currentTimeMillis());
        cacheProperties.save();
    }

    private long getLastResolvedTime(PropertiesFile cacheProperties) {
        String lastResolvedProp = cacheProperties.getProperty("resolved.time");
        if (lastResolvedProp != null) {
            return Long.parseLong(lastResolvedProp);
        }
        return cacheProperties.file.lastModified();
    }

    private PropertiesFile getCacheProperties(DependencyDescriptor dd, ResolvedModuleRevision moduleRevision) {
        DefaultRepositoryCacheManager cacheManager = (DefaultRepositoryCacheManager)this.getRepositoryCacheManager();
        PropertiesFile props = new PropertiesFile(new File(cacheManager.getRepositoryCacheRoot(), IvyPatternHelper.substitute((String)cacheManager.getDataFilePattern(), (ModuleRevisionId)moduleRevision.getId())), "ivy cached data file for " + dd.getDependencyRevisionId());
        return props;
    }

    public static class Interval
    implements CacheTimeoutStrategy {
        private long interval;

        public Interval(long interval) {
            this.interval = interval;
        }

        public boolean isCacheTimedOut(long lastResolvedTime) {
            return System.currentTimeMillis() - lastResolvedTime > this.interval;
        }
    }

    private static class PropertiesFile
    extends org.apache.ivy.util.PropertiesFile {
        private final File file;

        private PropertiesFile(File file, String header) {
            super(file, header);
            this.file = file;
        }
    }

    public static interface CacheTimeoutStrategy {
        public boolean isCacheTimedOut(long var1);
    }
}

