/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactoryInternal;
import org.gradle.util.WrapUtil;

public class DependencyDescriptorFactoryDelegate
implements DependencyDescriptorFactory {
    private Set<DependencyDescriptorFactoryInternal> dependencyDescriptorFactories;

    public DependencyDescriptorFactoryDelegate(DependencyDescriptorFactoryInternal ... dependencyDescriptorFactories) {
        this.dependencyDescriptorFactories = WrapUtil.toSet(dependencyDescriptorFactories);
    }

    public void addDependencyDescriptor(String configuration, DefaultModuleDescriptor moduleDescriptor, ModuleDependency dependency) {
        DependencyDescriptorFactoryInternal factoryInternal = this.findFactoryForDependency(dependency);
        factoryInternal.addDependencyDescriptor(configuration, moduleDescriptor, dependency);
    }

    public ModuleRevisionId createModuleRevisionId(ModuleDependency dependency) {
        DependencyDescriptorFactoryInternal factoryInternal = this.findFactoryForDependency(dependency);
        return factoryInternal.createModuleRevisionId(dependency);
    }

    private DependencyDescriptorFactoryInternal findFactoryForDependency(ModuleDependency dependency) {
        for (DependencyDescriptorFactoryInternal dependencyDescriptorFactoryInternal : this.dependencyDescriptorFactories) {
            if (!dependencyDescriptorFactoryInternal.canConvert(dependency)) continue;
            return dependencyDescriptorFactoryInternal;
        }
        throw new InvalidUserDataException("Can't map dependency of type: " + dependency.getClass());
    }
}

