/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish.maven;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.XmlProvider;
import org.gradle.api.internal.XmlTransformer;
import org.gradle.api.internal.artifacts.publish.maven.dependencies.PomDependenciesConverter;
import org.gradle.api.internal.artifacts.publish.maven.pombuilder.CustomModelBuilder;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenPom
implements MavenPom {
    private PomDependenciesConverter pomDependenciesConverter;
    private FileResolver fileResolver;
    private MavenProject mavenProject = new MavenProject();
    private Conf2ScopeMappingContainer scopeMappings;
    private ActionBroadcast<MavenPom> whenConfiguredActions = new ActionBroadcast();
    private XmlTransformer withXmlActions = new XmlTransformer();
    private ConfigurationContainer configurations;

    public DefaultMavenPom(ConfigurationContainer configurationContainer, Conf2ScopeMappingContainer scopeMappings, PomDependenciesConverter pomDependenciesConverter, FileResolver fileResolver) {
        this.configurations = configurationContainer;
        this.scopeMappings = scopeMappings;
        this.pomDependenciesConverter = pomDependenciesConverter;
        this.fileResolver = fileResolver;
        this.mavenProject.setModelVersion("4.0.0");
    }

    @Override
    public Conf2ScopeMappingContainer getScopeMappings() {
        return this.scopeMappings;
    }

    @Override
    public ConfigurationContainer getConfigurations() {
        return this.configurations;
    }

    @Override
    public DefaultMavenPom setConfigurations(ConfigurationContainer configurations) {
        this.configurations = configurations;
        return this;
    }

    @Override
    public DefaultMavenPom setGroupId(String groupId) {
        this.getModel().setGroupId(groupId);
        return this;
    }

    @Override
    public String getGroupId() {
        return this.getModel().getGroupId();
    }

    @Override
    public DefaultMavenPom setArtifactId(String artifactId) {
        this.getModel().setArtifactId(artifactId);
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.getModel().getArtifactId();
    }

    @Override
    public DefaultMavenPom setDependencies(List<Dependency> dependencies) {
        this.getModel().setDependencies(dependencies);
        return this;
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.getModel().getDependencies();
    }

    public DefaultMavenPom setName(String name) {
        this.getModel().setName(name);
        return this;
    }

    public String getName() {
        return this.getModel().getName();
    }

    @Override
    public DefaultMavenPom setVersion(String version) {
        this.getModel().setVersion(version);
        return this;
    }

    @Override
    public String getVersion() {
        return this.getModel().getVersion();
    }

    @Override
    public String getPackaging() {
        return this.getModel().getPackaging();
    }

    @Override
    public DefaultMavenPom setPackaging(String packaging) {
        this.getModel().setPackaging(packaging);
        return this;
    }

    @Override
    public DefaultMavenPom project(Closure cl) {
        CustomModelBuilder pomBuilder = new CustomModelBuilder(this.getModel());
        InvokerHelper.invokeMethod((Object)((Object)pomBuilder), (String)"project", (Object)cl);
        return this;
    }

    @Override
    public Model getModel() {
        return this.mavenProject.getModel();
    }

    @Override
    public DefaultMavenPom setModel(Model model) {
        this.mavenProject = new MavenProject(model);
        return this;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public DefaultMavenPom setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        return this;
    }

    public List<Dependency> getGeneratedDependencies() {
        if (this.configurations == null) {
            return Collections.emptyList();
        }
        return this.pomDependenciesConverter.convert(this.getScopeMappings(), this.configurations.getAll());
    }

    @Override
    public DefaultMavenPom getEffectivePom() {
        DefaultMavenPom effectivePom = new DefaultMavenPom(null, this.scopeMappings, this.pomDependenciesConverter, this.fileResolver);
        try {
            effectivePom.setMavenProject((MavenProject)this.mavenProject.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        effectivePom.getDependencies().addAll(this.getGeneratedDependencies());
        effectivePom.withXmlActions = this.withXmlActions;
        this.whenConfiguredActions.execute(effectivePom);
        return effectivePom;
    }

    public PomDependenciesConverter getPomDependenciesConverter() {
        return this.pomDependenciesConverter;
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public DefaultMavenPom setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        return this;
    }

    @Override
    public DefaultMavenPom writeTo(Writer pomWriter) {
        this.getEffectivePom().writeNonEffectivePom(pomWriter);
        return this;
    }

    @Override
    public DefaultMavenPom writeTo(Object path) {
        DefaultMavenPom defaultMavenPom;
        FileOutputStream stream = null;
        try {
            File file = this.fileResolver.resolve(path);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            stream = new FileOutputStream(file);
            this.getEffectivePom().writeNonEffectivePom(stream);
            defaultMavenPom = this;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)stream);
        return defaultMavenPom;
    }

    private void writeNonEffectivePom(Writer pomWriter) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.mavenProject.writeModel((Writer)stringWriter);
            this.withXmlActions.transform(stringWriter.toString(), pomWriter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtils.closeQuietly((Writer)pomWriter);
        }
    }

    private void writeNonEffectivePom(OutputStream stream) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.mavenProject.writeModel((Writer)stringWriter);
            this.withXmlActions.transform(stringWriter.toString(), stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }

    @Override
    public DefaultMavenPom whenConfigured(Closure closure) {
        this.whenConfiguredActions.add(closure);
        return this;
    }

    @Override
    public DefaultMavenPom whenConfigured(Action<MavenPom> action) {
        this.whenConfiguredActions.add(action);
        return this;
    }

    @Override
    public DefaultMavenPom withXml(Closure closure) {
        this.withXmlActions.addAction(closure);
        return this;
    }

    @Override
    public DefaultMavenPom withXml(Action<XmlProvider> action) {
        this.withXmlActions.addAction(action);
        return this;
    }
}

