/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.file.SimpleFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private static final int MAX_OUT_OF_DATE_MESSAGES = 10;
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskArtifactStateRepository.class);
    private final CacheRepository repository;
    private final FileSnapshotter inputFilesSnapshotter;
    private final FileSnapshotter outputFilesSnapshotter;
    private PersistentIndexedCache<String, TaskHistory> taskHistoryCache;
    private DefaultSerializer<TaskHistory> serializer;

    public DefaultTaskArtifactStateRepository(CacheRepository repository, FileSnapshotter inputFilesSnapshotter, FileSnapshotter outputFilesSnapshotter) {
        this.repository = repository;
        this.inputFilesSnapshotter = inputFilesSnapshotter;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
    }

    @Override
    public TaskArtifactState getStateFor(TaskInternal task) {
        if (this.taskHistoryCache == null) {
            this.loadTasks(task);
        }
        return new TaskArtifactStateImpl(task);
    }

    private void loadTasks(TaskInternal task) {
        this.serializer = new DefaultSerializer();
        this.taskHistoryCache = this.repository.cache("taskArtifacts").forObject(task.getProject().getGradle()).open().openIndexedCache(this.serializer);
    }

    private static Set<String> outputFiles(TaskInternal task) {
        HashSet<String> outputFiles = new HashSet<String>();
        for (File file : task.getOutputs().getFiles()) {
            outputFiles.add(file.getAbsolutePath());
        }
        return outputFiles;
    }

    private class TaskArtifactStateImpl
    implements TaskArtifactState {
        private final TaskInternal task;
        private final TaskHistory history;
        private final TaskExecution execution;

        public TaskArtifactStateImpl(TaskInternal task) {
            this.task = task;
            this.history = this.getHistory();
            this.execution = this.getExecution();
        }

        public boolean isUpToDate() {
            List<String> messages = this.execution.isUpToDate();
            if (messages == null || messages.isEmpty()) {
                LOGGER.info("Skipping {} as it is up-to-date.", this.task);
                return true;
            }
            if (LOGGER.isInfoEnabled()) {
                Formatter formatter = new Formatter();
                formatter.format("Executing %s due to:", this.task);
                for (int i = 0; i < messages.size() && i < 10; ++i) {
                    String message = messages.get(i);
                    formatter.format("%n%s", message);
                }
                if (messages.size() > 10) {
                    formatter.format("%n%d more ...", messages.size() - 10);
                }
                LOGGER.info(formatter.toString());
            }
            return false;
        }

        public FileCollection getOutputFiles() {
            return this.execution.getPreviousOutputFiles();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TaskHistory getHistory() {
            ClassLoader original = DefaultTaskArtifactStateRepository.this.serializer.getClassLoader();
            DefaultTaskArtifactStateRepository.this.serializer.setClassLoader(this.task.getClass().getClassLoader());
            try {
                TaskHistory history = (TaskHistory)DefaultTaskArtifactStateRepository.this.taskHistoryCache.get(this.task.getPath());
                TaskHistory taskHistory = history == null ? new TaskHistory() : history;
                return taskHistory;
            }
            finally {
                DefaultTaskArtifactStateRepository.this.serializer.setClassLoader(original);
            }
        }

        public TaskExecution getExecution() {
            if (!this.task.getOutputs().getHasOutput()) {
                return new NoDeclaredArtifactsExecution(this.task);
            }
            Set outputFiles = DefaultTaskArtifactStateRepository.outputFiles(this.task);
            TaskConfiguration bestMatch = null;
            int bestMatchOverlap = 0;
            for (TaskConfiguration configuration : this.history.configurations) {
                if (outputFiles.size() == 0 && configuration.outputFiles.size() == 0) {
                    bestMatch = configuration;
                    break;
                }
                HashSet intersection = new HashSet(outputFiles);
                intersection.retainAll(configuration.outputFiles);
                if (intersection.size() > bestMatchOverlap) {
                    bestMatch = configuration;
                    bestMatchOverlap = intersection.size();
                }
                if (bestMatchOverlap != outputFiles.size()) continue;
                break;
            }
            if (bestMatch == null) {
                return new HistoricExecution(this.history, this.task, null, DefaultTaskArtifactStateRepository.this.inputFilesSnapshotter, DefaultTaskArtifactStateRepository.this.outputFilesSnapshotter);
            }
            return new HistoricExecution(this.history, this.task, bestMatch, DefaultTaskArtifactStateRepository.this.inputFilesSnapshotter, DefaultTaskArtifactStateRepository.this.outputFilesSnapshotter);
        }

        public void update() {
            if (this.execution.snapshot()) {
                DefaultTaskArtifactStateRepository.this.taskHistoryCache.put(this.task.getPath(), this.history);
            }
        }
    }

    private static class TaskConfiguration
    implements Serializable {
        private final String taskClass;
        private Set<String> outputFiles;
        private Map<String, Object> inputProperties;
        private FileCollectionSnapshot inputFilesSnapshot;
        private FileCollectionSnapshot outputFilesSnapshot;

        private TaskConfiguration(TaskInternal task, FileCollectionSnapshot inputFilesSnapshot) {
            this.taskClass = task.getClass().getName();
            this.outputFiles = DefaultTaskArtifactStateRepository.outputFiles(task);
            this.inputProperties = new HashMap<String, Object>(task.getInputs().getProperties());
            this.inputFilesSnapshot = inputFilesSnapshot;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoricExecution
    implements TaskExecution {
        private final TaskHistory history;
        private final TaskInternal task;
        private final TaskConfiguration lastExecution;
        private final FileSnapshotter inputFilesSnapshotter;
        private final FileSnapshotter outputFilesSnapshotter;
        private boolean upToDate;
        private TaskConfiguration thisExecution;
        private FileCollectionSnapshot outputFilesBefore;

        public HistoricExecution(TaskHistory history, TaskInternal task, TaskConfiguration lastExecution, FileSnapshotter inputFilesSnapshotter, FileSnapshotter outputFilesSnapshotter) {
            this.history = history;
            this.task = task;
            this.lastExecution = lastExecution;
            this.inputFilesSnapshotter = inputFilesSnapshotter;
            this.outputFilesSnapshotter = outputFilesSnapshotter;
        }

        private void calcCurrentState() {
            if (this.thisExecution != null) {
                return;
            }
            FileCollectionSnapshot inputFilesSnapshot = this.inputFilesSnapshotter.snapshot(this.task.getInputs().getFiles());
            this.thisExecution = new TaskConfiguration(this.task, inputFilesSnapshot);
            this.outputFilesBefore = this.outputFilesSnapshotter.snapshot(this.task.getOutputs().getFiles());
        }

        @Override
        public FileCollection getPreviousOutputFiles() {
            return this.lastExecution != null ? this.lastExecution.outputFilesSnapshot.getFiles() : new SimpleFileCollection(new File[0]);
        }

        @Override
        public List<String> isUpToDate() {
            this.calcCurrentState();
            if (this.lastExecution == null) {
                return Collections.singletonList(String.format("No history is available for %s.", this.task));
            }
            if (!this.task.getClass().getName().equals(this.lastExecution.taskClass)) {
                return Collections.singletonList(String.format("%s has changed type from '%s' to '%s'.", StringUtils.capitalize((String)this.task.toString()), this.lastExecution.taskClass, this.task.getClass().getName()));
            }
            ArrayList<String> messages = new ArrayList<String>();
            this.checkInputProperties(messages);
            if (!messages.isEmpty()) {
                return messages;
            }
            this.checkInputs(messages);
            if (!messages.isEmpty()) {
                return messages;
            }
            this.checkOutputs(messages);
            if (!messages.isEmpty()) {
                return messages;
            }
            this.upToDate = true;
            return Collections.emptyList();
        }

        private void checkOutputs(final Collection<String> messages) {
            this.outputFilesBefore.changesSince(this.lastExecution.outputFilesSnapshot, new ChangeListener<File>(){

                @Override
                public void added(File element) {
                    messages.add(String.format("Output file '%s' has been added for %s.", element, HistoricExecution.this.task));
                }

                @Override
                public void removed(File element) {
                    messages.add(String.format("Output file %s has been removed for %s.", element.getAbsolutePath(), HistoricExecution.this.task));
                }

                @Override
                public void changed(File element) {
                    messages.add(String.format("Output file %s for %s has changed.", element.getAbsolutePath(), HistoricExecution.this.task));
                }
            });
        }

        private void checkInputs(final Collection<String> messages) {
            this.thisExecution.inputFilesSnapshot.changesSince(this.lastExecution.inputFilesSnapshot, new ChangeListener<File>(){

                @Override
                public void added(File file) {
                    messages.add(String.format("Input file %s for %s added.", file, HistoricExecution.this.task));
                }

                @Override
                public void removed(File file) {
                    messages.add(String.format("Input file %s for %s removed.", file, HistoricExecution.this.task));
                }

                @Override
                public void changed(File file) {
                    messages.add(String.format("Input file %s for %s has changed.", file, HistoricExecution.this.task));
                }
            });
        }

        private void checkInputProperties(final Collection<String> messages) {
            DiffUtil.diff(this.thisExecution.inputProperties, this.lastExecution.inputProperties, new ChangeListener<Map.Entry<String, Object>>(){

                @Override
                public void added(Map.Entry<String, Object> element) {
                    messages.add(String.format("Input property '%s' has been added for %s", element.getKey(), HistoricExecution.this.task));
                }

                @Override
                public void removed(Map.Entry<String, Object> element) {
                    messages.add(String.format("Input property '%s' has been removed for %s", element.getKey(), HistoricExecution.this.task));
                }

                @Override
                public void changed(Map.Entry<String, Object> element) {
                    messages.add(String.format("Value of input property '%s' has changed for %s", element.getKey(), HistoricExecution.this.task));
                }
            });
        }

        @Override
        public boolean snapshot() {
            this.calcCurrentState();
            if (this.upToDate) {
                return false;
            }
            FileCollectionSnapshot lastExecutionOutputFiles = this.lastExecution == null ? this.outputFilesSnapshotter.snapshot() : this.lastExecution.outputFilesSnapshot;
            FileCollectionSnapshot newOutputFiles = this.outputFilesBefore.changesSince(lastExecutionOutputFiles).applyTo(lastExecutionOutputFiles, new ChangeListener<FileCollectionSnapshot.Merge>(){

                @Override
                public void added(FileCollectionSnapshot.Merge element) {
                    element.ignore();
                }

                @Override
                public void removed(FileCollectionSnapshot.Merge element) {
                }

                @Override
                public void changed(FileCollectionSnapshot.Merge element) {
                }
            });
            FileCollectionSnapshot outputFilesAfter = this.outputFilesSnapshotter.snapshot(this.task.getOutputs().getFiles());
            this.thisExecution.outputFilesSnapshot = outputFilesAfter.changesSince(this.outputFilesBefore).applyTo(newOutputFiles);
            this.history.addConfiguration(this.thisExecution);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoDeclaredArtifactsExecution
    implements TaskExecution {
        private final TaskInternal task;

        private NoDeclaredArtifactsExecution(TaskInternal task) {
            this.task = task;
        }

        @Override
        public List<String> isUpToDate() {
            ArrayList<String> messages = new ArrayList<String>();
            if (!this.task.getOutputs().getHasOutput()) {
                messages.add(String.format("%s has not declared any outputs.", StringUtils.capitalize((String)this.task.toString())));
            }
            return messages;
        }

        @Override
        public boolean snapshot() {
            return false;
        }

        @Override
        public FileCollection getPreviousOutputFiles() {
            return new SimpleFileCollection(new File[0]);
        }
    }

    private static class TaskHistory
    implements Serializable {
        private static final int MAX_HISTORY_ENTRIES = 3;
        private final List<TaskConfiguration> configurations = new ArrayList<TaskConfiguration>();

        private TaskHistory() {
        }

        public void addConfiguration(TaskConfiguration configuration) {
            this.configurations.add(0, configuration);
            while (this.configurations.size() > 3) {
                this.configurations.remove(3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TaskExecution {
        public List<String> isUpToDate();

        public boolean snapshot();

        public FileCollection getPreviousOutputFiles();
    }
}

