/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;

public abstract class AbstractFileTreeElement
implements FileTreeElement {
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.getRelativePath().getLastName();
    }

    public String getPath() {
        return this.getRelativePath().getPathString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream outstr) {
        try {
            InputStream inputStream = this.open();
            try {
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outstr);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean copyTo(File target) {
        try {
            target.getParentFile().mkdirs();
            if (this.isDirectory()) {
                target.mkdirs();
            } else {
                this.copyFile(target);
            }
            target.setLastModified(this.getLastModified());
            return true;
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not copy %s to '%s'.", this.getDisplayName(), target), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File target) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(target);
        try {
            this.copyTo(outputStream);
        }
        finally {
            outputStream.close();
        }
    }
}

