/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.DefaultConfigurableFileTree;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileCollection
extends AbstractFileCollection {
    @Override
    public Set<File> getFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            files.addAll(fileCollection.getFiles());
        }
        return files;
    }

    @Override
    public boolean contains(File file) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (!fileCollection.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (fileCollection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            fileCollection.addToAntBuilder(builder, nodeName, FileCollection.AntType.ResourceCollection);
        }
    }

    @Override
    protected Collection<DefaultConfigurableFileTree> getAsFileTrees() {
        ArrayList<DefaultConfigurableFileTree> fileTree = new ArrayList<DefaultConfigurableFileTree>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            AbstractFileCollection collection = (AbstractFileCollection)fileCollection;
            fileTree.addAll(collection.getAsFileTrees());
        }
        return fileTree;
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            @Override
            protected void addSourceCollections(Collection<FileCollection> sources) {
                for (FileCollection fileCollection : CompositeFileCollection.this.getSourceCollections()) {
                    sources.add(fileCollection.getAsFileTree());
                }
            }

            @Override
            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return CompositeFileCollection.this.getBuildDependencies();
            }
        };
    }

    @Override
    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new CompositeFileCollection(){

            @Override
            protected void addSourceCollections(Collection<FileCollection> sources) {
                for (FileCollection fileCollection : CompositeFileCollection.this.getSourceCollections()) {
                    sources.add(fileCollection.filter(filterSpec));
                }
            }

            @Override
            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return CompositeFileCollection.this.getBuildDependencies();
            }
        };
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.addDependencies(context);
            }
        };
    }

    protected void addDependencies(TaskDependencyResolveContext context) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            context.add(fileCollection);
        }
    }

    protected List<? extends FileCollection> getSourceCollections() {
        ArrayList<FileCollection> collections = new ArrayList<FileCollection>();
        this.addSourceCollections(collections);
        return collections;
    }

    protected abstract void addSourceCollections(Collection<FileCollection> var1);
}

