/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.api.internal.file.DirectoryWalker;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirectoryWalker
implements DirectoryWalker {
    private static Logger logger = LoggerFactory.getLogger(DefaultDirectoryWalker.class);
    private FileVisitor visitor;
    private Spec<FileTreeElement> spec = Specs.satisfyAll();
    private boolean depthFirst;

    public DefaultDirectoryWalker(FileVisitor visitor) {
        this.visitor = visitor;
    }

    public DefaultDirectoryWalker match(PatternSet patternSet) {
        this.spec = patternSet.getAsSpec();
        return this;
    }

    public void start(File startFile) {
        File root = GFileUtils.canonicalise(startFile);
        AtomicBoolean stopFlag = new AtomicBoolean();
        if (root.exists()) {
            if (root.isFile()) {
                this.processSingleFile(root, stopFlag);
            } else {
                this.walkDir(root, new RelativePath(false, new String[0]), stopFlag);
            }
        } else {
            logger.info("file or directory '" + startFile.toString() + "', not found");
        }
    }

    private void processSingleFile(File file, AtomicBoolean stopFlag) {
        RelativePath path = new RelativePath(true, file.getName());
        FileVisitDetailsImpl details = new FileVisitDetailsImpl(file, path, stopFlag);
        if (this.isAllowed(details)) {
            this.visitor.visitFile(details);
        }
    }

    private void walkDir(File file, RelativePath path, AtomicBoolean stopFlag) {
        int i;
        File[] children = file.listFiles();
        if (children == null) {
            if (file.isDirectory() && !file.canRead()) {
                throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
            }
            throw new GradleException(String.format("Could not list contents of '%s'.", file));
        }
        ArrayList<FileVisitDetailsImpl> dirs = new ArrayList<FileVisitDetailsImpl>();
        for (i = 0; !stopFlag.get() && i < children.length; ++i) {
            File child = children[i];
            boolean isFile = child.isFile();
            RelativePath childPath = path.append(isFile, child.getName());
            FileVisitDetailsImpl details = new FileVisitDetailsImpl(child, childPath, stopFlag);
            if (!this.isAllowed(details)) continue;
            if (isFile) {
                this.visitor.visitFile(details);
                continue;
            }
            dirs.add(details);
        }
        for (i = 0; !stopFlag.get() && i < dirs.size(); ++i) {
            FileVisitDetailsImpl dir = (FileVisitDetailsImpl)dirs.get(i);
            if (this.depthFirst) {
                this.walkDir(dir.getFile(), dir.getRelativePath(), stopFlag);
                this.visitor.visitDir(dir);
                continue;
            }
            this.visitor.visitDir(dir);
            this.walkDir(dir.getFile(), dir.getRelativePath(), stopFlag);
        }
    }

    boolean isAllowed(FileTreeElement element) {
        return this.spec.isSatisfiedBy(element);
    }

    public DirectoryWalker depthFirst() {
        this.depthFirst = true;
        return this;
    }

    private static class FileVisitDetailsImpl
    extends DefaultFileTreeElement
    implements FileVisitDetails {
        private final AtomicBoolean stop;

        private FileVisitDetailsImpl(File file, RelativePath relativePath, AtomicBoolean stop) {
            super(file, relativePath);
            this.stop = stop;
        }

        public void stopVisiting() {
            this.stop.set(true);
        }
    }
}

