/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.PathResolvingFileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final PathResolvingFileCollection srcDirs;
    private final String displayName;
    private final FileResolver resolver;
    private final PatternFilterable patterns = new PatternSet();
    private final PatternFilterable filter = new PatternSet();

    public DefaultSourceDirectorySet(FileResolver fileResolver) {
        this("source set", fileResolver);
    }

    public DefaultSourceDirectorySet(String displayName, FileResolver fileResolver) {
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.srcDirs = new PathResolvingFileCollection(fileResolver, null, new Object[0]);
    }

    @Override
    public Set<File> getSrcDirs() {
        return this.srcDirs.getFiles();
    }

    @Override
    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    @Override
    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    @Override
    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.patterns.setIncludes(includes);
        return this;
    }

    @Override
    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.patterns.setExcludes(excludes);
        return this;
    }

    @Override
    public PatternFilterable include(String ... includes) {
        this.patterns.include(includes);
        return this;
    }

    @Override
    public PatternFilterable include(Iterable<String> includes) {
        this.patterns.include(includes);
        return this;
    }

    @Override
    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    @Override
    public PatternFilterable include(Closure includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Iterable<String> excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(String ... excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Closure excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    @Override
    protected void addSourceCollections(Collection<FileCollection> sources) {
        for (File sourceDir : this.getExistingSourceDirs()) {
            DefaultConfigurableFileTree fileset = new DefaultConfigurableFileTree(sourceDir, this.resolver, null);
            fileset.getPatternSet().copyFrom(this.patterns);
            sources.add(fileset.matching(this.filter));
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected Set<File> getExistingSourceDirs() {
        LinkedHashSet<File> existingSourceDirs = new LinkedHashSet<File>();
        for (File srcDir : this.srcDirs) {
            if (srcDir.isDirectory()) {
                existingSourceDirs.add(srcDir);
                continue;
            }
            if (!srcDir.exists()) continue;
            throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", srcDir));
        }
        return existingSourceDirs;
    }

    @Override
    public SourceDirectorySet srcDir(Object srcDir) {
        this.srcDirs.from(srcDir);
        return this;
    }

    @Override
    public SourceDirectorySet srcDirs(Object ... srcDirs) {
        this.srcDirs.from(srcDirs);
        return this;
    }

    @Override
    public SourceDirectorySet setSrcDirs(Iterable<Object> srcPaths) {
        this.srcDirs.clear();
        this.srcDirs.from(srcPaths);
        return this;
    }
}

