/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.SingletonFileCollection;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathResolvingFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection {
    private final List<Object> files;
    private final String displayName;
    private final FileResolver resolver;
    private final DefaultTaskDependency buildDependency;

    public PathResolvingFileCollection(FileResolver fileResolver, TaskResolver taskResolver, Object ... files) {
        this("file collection", fileResolver, taskResolver, files);
    }

    public PathResolvingFileCollection(String displayName, FileResolver fileResolver, TaskResolver taskResolver, Object ... files) {
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.files = new ArrayList<Object>(Arrays.asList(files));
        this.buildDependency = new DefaultTaskDependency(taskResolver);
    }

    public PathResolvingFileCollection clear() {
        this.files.clear();
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public List<?> getSources() {
        return this.files;
    }

    @Override
    public ConfigurableFileCollection from(Object ... paths) {
        for (Object path : paths) {
            this.files.add(path);
        }
        return this;
    }

    @Override
    public ConfigurableFileCollection builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getValues();
    }

    @Override
    public ConfigurableFileCollection setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    @Override
    protected void addDependencies(TaskDependencyResolveContext context) {
        super.addDependencies(context);
        context.add(this.buildDependency);
    }

    @Override
    protected void addSourceCollections(Collection<FileCollection> sources) {
        for (Object element : this.resolveToFilesAndFileCollections()) {
            if (element instanceof FileCollection) {
                FileCollection collection = (FileCollection)element;
                sources.add(collection);
                continue;
            }
            File file = (File)element;
            sources.add(new SingletonFileCollection(file, this.buildDependency));
        }
    }

    private List<Object> resolveToFilesAndFileCollections() {
        ArrayList<Object> result = new ArrayList<Object>();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addAll(this.files);
        while (!queue.isEmpty()) {
            Object first = queue.removeFirst();
            if (first instanceof FileCollection) {
                result.add(first);
                continue;
            }
            if (first instanceof Closure) {
                Closure closure = (Closure)first;
                Object closureResult = closure.call();
                if (closureResult == null) continue;
                queue.addFirst(closureResult);
                continue;
            }
            if (first instanceof Collection) {
                Collection collection = (Collection)first;
                queue.addAll(0, collection);
                continue;
            }
            if (first instanceof Object[]) {
                Object[] array = (Object[])first;
                queue.addAll(0, Arrays.asList(array));
                continue;
            }
            if (first instanceof Callable) {
                Object callableResult;
                Callable callable = (Callable)first;
                try {
                    callableResult = callable.call();
                }
                catch (Exception e) {
                    throw UncheckedException.asUncheckedException(e);
                }
                if (callableResult == null) continue;
                queue.add(0, callableResult);
                continue;
            }
            result.add(this.resolver.resolve(first));
        }
        return result;
    }
}

