/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.SingletonFileTree;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SingletonFileCollection
extends AbstractFileCollection {
    private final File file;
    private final TaskDependency builtBy;

    public SingletonFileCollection(File file, TaskDependency builtBy) {
        this.file = file;
        this.builtBy = builtBy;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.builtBy;
    }

    @Override
    public String getDisplayName() {
        return String.format("file '%s'", this.file);
    }

    @Override
    public Set<File> getFiles() {
        return Collections.singleton(this.file);
    }

    @Override
    public FileTree getAsFileTree() {
        return new SingletonFileTree(this.file, this.builtBy);
    }
}

