/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Collection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SingletonFileTree
extends CompositeFileTree {
    private final File file;
    private final TaskDependency builtBy;

    public SingletonFileTree(File file, TaskDependency builtBy) {
        this.file = file;
        this.builtBy = builtBy;
    }

    @Override
    public String getDisplayName() {
        return String.format("file '%s'", this.file);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.builtBy;
    }

    @Override
    protected void addSourceCollections(Collection<FileCollection> sources) {
        if (this.file.isDirectory()) {
            sources.add(new DefaultConfigurableFileTree(this.file, null, null));
        } else if (this.file.isFile()) {
            sources.add(new FileFileTree());
        }
    }

    private class FileFileTree
    extends AbstractFileTree {
        private FileFileTree() {
        }

        public String getDisplayName() {
            return SingletonFileTree.this.getDisplayName();
        }

        public FileTree visit(FileVisitor visitor) {
            visitor.visitFile(new FileVisitDetailsImpl());
            return this;
        }
    }

    private class FileVisitDetailsImpl
    extends DefaultFileTreeElement
    implements FileVisitDetails {
        private FileVisitDetailsImpl() {
            super(SingletonFileTree.this.file, new RelativePath(true, SingletonFileTree.this.file.getName()));
        }

        public void stopVisiting() {
        }
    }
}

