/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.CompositeFileTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionFileTree
extends CompositeFileTree {
    private final Set<FileTree> sourceTrees;
    private final String displayName;

    public UnionFileTree(FileTree ... sourceTrees) {
        this("file tree", Arrays.asList(sourceTrees));
    }

    public UnionFileTree(String displayName, FileTree ... sourceTrees) {
        this(displayName, Arrays.asList(sourceTrees));
    }

    public UnionFileTree(String displayName, Collection<? extends FileTree> sourceTrees) {
        this.displayName = displayName;
        this.sourceTrees = new LinkedHashSet<FileTree>(sourceTrees);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    protected void addSourceCollections(Collection<FileCollection> sources) {
        sources.addAll(this.sourceTrees);
    }

    @Override
    public UnionFileTree add(FileCollection source) {
        if (!(source instanceof FileTree)) {
            throw new UnsupportedOperationException(String.format("Can only add FileTree instances to %s.", this.getDisplayName()));
        }
        this.sourceTrees.add((FileTree)source);
        return this;
    }
}

