/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.file.DeleteAction;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteActionImpl
implements DeleteAction {
    private static Logger logger = LoggerFactory.getLogger(DeleteActionImpl.class);
    private FileResolver fileResolver;

    public DeleteActionImpl(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public boolean delete(Object ... deletes) {
        boolean didWork = false;
        for (File file : this.fileResolver.resolveFiles(deletes)) {
            if (!file.exists()) continue;
            logger.debug("Deleting {}", (Object)file);
            didWork = true;
            if (file.isFile()) {
                GFileUtils.deleteQuietly(file);
                continue;
            }
            GFileUtils.deleteDirectory(file);
        }
        return didWork;
    }
}

