/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;
import org.gradle.api.internal.file.copy.FileCopyAction;

public class FileCopySpecVisitor
extends EmptyCopySpecVisitor {
    private File baseDestDir;
    private boolean didWork;

    public void startVisit(CopyAction action) {
        this.baseDestDir = ((FileCopyAction)action).getDestinationDir();
        if (this.baseDestDir == null) {
            throw new InvalidUserDataException("No copy destination directory has been specified, use 'into' to specify a target directory.");
        }
    }

    public void visitFile(FileVisitDetails source) {
        File target = source.getRelativePath().getFile(this.baseDestDir);
        this.copyFile(source, target);
    }

    public boolean getDidWork() {
        return this.didWork;
    }

    void copyFile(FileTreeElement srcFile, File destFile) {
        boolean copied = srcFile.copyTo(destFile);
        if (copied) {
            this.didWork = true;
        }
    }
}

