/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRegistry
implements PluginRegistry {
    private final Map<String, Class<? extends Plugin>> idMappings = new HashMap<String, Class<? extends Plugin>>();
    private final DefaultPluginRegistry parent;
    private final ClassLoader classLoader;

    public DefaultPluginRegistry(ClassLoader classLoader) {
        this(null, classLoader);
    }

    private DefaultPluginRegistry(DefaultPluginRegistry parent, ClassLoader classLoader) {
        this.parent = parent;
        this.classLoader = classLoader;
    }

    @Override
    public PluginRegistry createChild(ClassLoader childClassPath) {
        return new DefaultPluginRegistry(this, childClassPath);
    }

    @Override
    public <T extends Plugin> T loadPlugin(Class<T> pluginClass) {
        if (this.parent != null) {
            return this.parent.loadPlugin(pluginClass);
        }
        if (!Plugin.class.isAssignableFrom(pluginClass)) {
            throw new InvalidUserDataException(String.format("Cannot create plugin of type '%s' as it does not implement the Plugin interface.", pluginClass.getSimpleName()));
        }
        try {
            return (T)((Plugin)pluginClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", pluginClass.getSimpleName()), e.getCause());
        }
        catch (Exception e) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", pluginClass.getSimpleName()), e);
        }
    }

    @Override
    public Class<? extends Plugin> getTypeForId(String pluginId) {
        Class<? extends Plugin> implClass;
        if (this.parent != null) {
            try {
                return this.parent.getTypeForId(pluginId);
            }
            catch (UnknownPluginException e) {
                // empty catch block
            }
        }
        if ((implClass = this.idMappings.get(pluginId)) != null) {
            return implClass;
        }
        URL resource = this.classLoader.getResource(String.format("META-INF/gradle-plugins/%s.properties", pluginId));
        if (resource == null) {
            throw new UnknownPluginException("Plugin with id '" + pluginId + "' not found.");
        }
        Properties properties = GUtil.loadProperties(resource);
        String implClassName = properties.getProperty("implementation-class");
        if (!GUtil.isTrue(implClassName)) {
            throw new PluginInstantiationException(String.format("No implementation class specified for plugin '%s' in %s.", pluginId, resource));
        }
        try {
            implClass = this.classLoader.loadClass(implClassName).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException(String.format("Could not find implementation class '%s' for plugin '%s' specified in %s.", implClass, pluginId, resource), e);
        }
        this.idMappings.put(pluginId, implClass);
        return implClass;
    }
}

