/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Delete;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdePlugin
implements Plugin<Project> {
    private Task lifecycleTask;
    private Task cleanTask;
    private Project project;

    @Override
    public void apply(Project target) {
        this.project = target;
        String lifecyleTaskName = this.getLifecycleTaskName();
        this.lifecycleTask = target.task(lifecyleTaskName);
        this.lifecycleTask.setGroup("IDE");
        this.cleanTask = target.task(this.cleanName(lifecyleTaskName));
        this.cleanTask.setGroup("IDE");
        this.onApply(target);
    }

    public Task getLifecycleTask() {
        return this.lifecycleTask;
    }

    public Task getCleanTask() {
        return this.cleanTask;
    }

    public Task getCleanTask(Task worker) {
        return this.project.getTasks().getByName(this.cleanName(worker.getName()));
    }

    private String cleanName(String taskName) {
        return String.format("clean%s", StringUtils.capitalize((String)taskName));
    }

    protected void addWorker(Task worker) {
        this.lifecycleTask.dependsOn(worker);
        Delete cleanWorker = this.project.getTasks().add(this.cleanName(worker.getName()), Delete.class);
        cleanWorker.delete(worker.getOutputs().getFiles());
        this.cleanTask.dependsOn(cleanWorker);
    }

    protected void onApply(Project target) {
    }

    protected abstract String getLifecycleTaskName();
}

