/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DefaultAutoCreateDomainObjectContainer;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicObjectHelper;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectScript;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.ServiceRegistryFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Directory;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ProjectEvaluator;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.process.ExecResult;
import org.gradle.util.Configurable;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProject
implements ProjectInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Project.class);
    private ServiceRegistryFactory services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private ProjectEvaluator projectEvaluator;
    private ScriptSource buildScriptSource;
    private final File projectDir;
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Object status;
    private final Map<String, Project> childProjects = new HashMap<String, Project>();
    private List<String> defaultTasks = new ArrayList<String>();
    private Set<Project> dependsOnProjects = new HashSet<Project>();
    private ProjectStateInternal state;
    private FileResolver fileResolver;
    private FileOperations fileOperations;
    private Factory<? extends AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private Object buildDir = "build";
    private PluginContainer pluginContainer;
    private final int depth;
    private TaskContainerInternal taskContainer;
    private TaskContainerInternal implicitTasksContainer;
    private IProjectRegistry<ProjectInternal> projectRegistry;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainer configurationContainer;
    private ArtifactHandler artifactHandler;
    private Factory<? extends RepositoryHandler> repositoryHandlerFactory;
    private RepositoryHandler repositoryHandler;
    private ScriptHandler scriptHandler;
    private ScriptClassLoaderProvider scriptClassLoaderProvider;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = new ListenerBroadcast<ProjectEvaluationListener>(ProjectEvaluationListener.class);
    private LoggingManagerInternal loggingManager;
    private DynamicObjectHelper dynamicObjectHelper;
    private String description;
    private final Path path;

    public AbstractProject(String name, ProjectInternal parent, File projectDir, ScriptSource buildScriptSource, GradleInternal gradle, ServiceRegistryFactory serviceRegistryFactory) {
        assert (name != null);
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        if (parent == null) {
            this.path = Path.ROOT;
            this.depth = 0;
        } else {
            String path = parent.absoluteProjectPath(name);
            this.depth = parent.getDepth() + 1;
            this.path = Path.path(path);
        }
        this.services = serviceRegistryFactory.createFor(this);
        this.fileResolver = this.services.get(FileResolver.class);
        this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        this.taskContainer = this.services.newInstance(TaskContainerInternal.class);
        this.implicitTasksContainer = this.services.newInstance(TaskContainerInternal.class);
        this.fileOperations = this.services.get(FileOperations.class);
        this.repositoryHandlerFactory = this.services.getFactory(RepositoryHandler.class);
        this.projectEvaluator = this.services.get(ProjectEvaluator.class);
        this.repositoryHandler = this.repositoryHandlerFactory.create();
        this.configurationContainer = this.services.get(ConfigurationContainer.class);
        this.pluginContainer = this.services.get(PluginContainer.class);
        this.artifactHandler = this.services.get(ArtifactHandler.class);
        this.dependencyHandler = this.services.get(DependencyHandler.class);
        this.scriptHandler = this.services.get(ScriptHandler.class);
        this.scriptClassLoaderProvider = this.services.get(ScriptClassLoaderProvider.class);
        this.projectRegistry = this.services.get(IProjectRegistry.class);
        this.loggingManager = this.services.get(LoggingManagerInternal.class);
        this.dynamicObjectHelper = new DynamicObjectHelper(this);
        this.dynamicObjectHelper.setConvention(this.services.get(Convention.class));
        if (parent != null) {
            this.dynamicObjectHelper.setParent(parent.getInheritedScope());
        }
        this.dynamicObjectHelper.addObject(this.taskContainer.getAsDynamicObject(), DynamicObjectHelper.Location.AfterConvention);
        this.evaluationListener.add(gradle.getProjectEvaluationBroadcaster());
    }

    @Override
    public RepositoryHandler createRepositoryHandler() {
        return this.repositoryHandlerFactory.create();
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.rootProject;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public PluginContainer getPlugins() {
        return this.pluginContainer;
    }

    public ProjectEvaluator getProjectEvaluator() {
        return this.projectEvaluator;
    }

    public void setProjectEvaluator(ProjectEvaluator projectEvaluator) {
        this.projectEvaluator = projectEvaluator;
    }

    @Override
    public ScriptHandler getBuildscript() {
        return this.scriptHandler;
    }

    @Override
    public void beforeCompile(ScriptPlugin configurer) {
        if (configurer.getSource() != this.buildScriptSource) {
            return;
        }
        configurer.setScriptBaseClass(ProjectScript.class);
        configurer.setClassLoaderProvider(this.scriptClassLoaderProvider);
    }

    @Override
    public void afterCompile(ScriptPlugin configurer, Script script) {
        if (configurer.getSource() != this.buildScriptSource) {
            return;
        }
        this.setScript(script);
    }

    @Override
    public File getBuildFile() {
        return this.getBuildscript().getSourceFile();
    }

    public void setScript(groovy.lang.Script buildScript) {
        this.dynamicObjectHelper.addObject(new BeanDynamicObject(buildScript).withNoProperties(), DynamicObjectHelper.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.dynamicObjectHelper;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.dynamicObjectHelper.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        return this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
    }

    @Override
    public void setGroup(Object group) {
        this.group = group;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public Object getStatus() {
        return this.status == null ? "release" : this.status;
    }

    @Override
    public void setStatus(Object status) {
        this.status = status;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.childProjects;
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public Set<Project> getDependsOnProjects() {
        return this.dependsOnProjects;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.dynamicObjectHelper.getAdditionalProperties();
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        return this.artifactHandler;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    @Override
    public RepositoryHandler getRepositories() {
        return this.repositoryHandler;
    }

    public Factory<? extends RepositoryHandler> getRepositoryHandlerFactory() {
        return this.repositoryHandlerFactory;
    }

    @Override
    public ConfigurationContainer getConfigurations() {
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    @Override
    public String getBuildDirName() {
        return this.buildDir.toString();
    }

    @Override
    public void setBuildDirName(String buildDirName) {
        DeprecationLogger.nagUser("Project.setBuildDirName()", "setBuildDir()");
        this.buildDir = buildDirName;
    }

    @Override
    public Convention getConvention() {
        return this.dynamicObjectHelper.getConvention();
    }

    @Override
    public void setConvention(Convention convention) {
        this.dynamicObjectHelper.setConvention(convention);
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public IProjectRegistry<ProjectInternal> getProjectRegistry() {
        return this.projectRegistry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProject that = (AbstractProject)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public int depthCompare(Project otherProject) {
        return new Integer(this.getDepth()).compareTo(otherProject.getDepth());
    }

    @Override
    public int compareTo(Project otherProject) {
        int depthCompare = this.depthCompare(otherProject);
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherProject.getPath());
        }
        return depthCompare;
    }

    @Override
    public String absolutePath(String path) {
        DeprecationLogger.nagUser("Project.absolutePath()", "Project.absoluteProjectPath()");
        return this.absoluteProjectPath(path);
    }

    @Override
    public String absoluteProjectPath(String path) {
        return this.path.absolutePath(path);
    }

    @Override
    public String relativeProjectPath(String path) {
        return this.path.relativePath(path);
    }

    @Override
    public Project project(String path) {
        Project project = this.findProject(path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public Project findProject(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.projectRegistry.getProject(this.absoluteProjectPath(path));
    }

    @Override
    public Set<Project> getAllprojects() {
        return new TreeSet<Project>(this.projectRegistry.getAllProjects(this.getPath()));
    }

    @Override
    public Set<Project> getSubprojects() {
        return new TreeSet<Project>(this.projectRegistry.getSubProjects(this.getPath()));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.configure(this.getSubprojects(), action);
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.configure(this.getAllprojects(), action);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return this.antBuilderFactory.create();
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public AbstractProject evaluate() {
        this.projectEvaluator.evaluate(this, this.state);
        this.state.rethrowFailure();
        return this;
    }

    @Override
    public Project usePlugin(String pluginId) {
        this.warnUsePluginDeprecated();
        this.pluginContainer.apply(pluginId);
        return this;
    }

    @Override
    public Project usePlugin(Class<? extends Plugin> pluginClass) {
        this.warnUsePluginDeprecated();
        this.pluginContainer.apply(pluginClass);
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public TaskContainerInternal getImplicitTasks() {
        return this.implicitTasksContainer;
    }

    @Override
    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    @Override
    public Task createTask(String name) {
        return this.createTask(new HashMap(), name, (Action<? super Task>)null);
    }

    @Override
    public Task createTask(Map<String, ?> args, String name) {
        return this.createTask(args, name, (Action<? super Task>)null);
    }

    @Override
    public Task createTask(String name, Action<? super Task> action) {
        return this.createTask(new HashMap(), name, action);
    }

    @Override
    public Task createTask(String name, Closure action) {
        return this.createTask((Map)new HashMap(), name, action);
    }

    public Task createTask(Map args, String name, Closure action) {
        this.warnCreateTaskDeprecated();
        HashMap<String, String> allArgs = new HashMap<String, String>(args);
        allArgs.put("name", name);
        allArgs.put("action", (String)action);
        return this.taskContainer.add(allArgs);
    }

    @Override
    public Task createTask(Map<String, ?> args, String name, Action<? super Task> action) {
        this.warnCreateTaskDeprecated();
        HashMap allArgs = new HashMap(args);
        allArgs.put("name", name);
        if (action != null) {
            allArgs.put("action", action);
        }
        return this.taskContainer.add(allArgs);
    }

    private void warnCreateTaskDeprecated() {
        DeprecationLogger.nagUser("Project.createTask()", "task()");
    }

    private void warnUsePluginDeprecated() {
        DeprecationLogger.nagUser("Project.usePlugin()", "apply()");
    }

    @Override
    public void addChildProject(ProjectInternal childProject) {
        this.childProjects.put(childProject.getName(), childProject);
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.file(this.buildDir);
    }

    @Override
    public void setBuildDir(Object path) {
        this.buildDir = path;
    }

    @Override
    public void dependsOn(String path) {
        this.dependsOn(path, true);
    }

    @Override
    public void dependsOn(String path, boolean evaluateDependsOnProject) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        this.dependsOnProjects.add(this.project(path));
        if (evaluateDependsOnProject) {
            this.evaluationDependsOn(path);
        }
    }

    @Override
    public Project evaluationDependsOn(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        DefaultProject projectToEvaluate = (DefaultProject)this.project(path);
        if (projectToEvaluate.getState().getExecuting()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        return projectToEvaluate.evaluate();
    }

    @Override
    public Project childrenDependOnMe() {
        for (Project project : this.childProjects.values()) {
            project.dependsOn(this.getPath(), false);
        }
        return this;
    }

    @Override
    public Project dependsOnChildren() {
        return this.dependsOnChildren(false);
    }

    @Override
    public Project dependsOnChildren(boolean evaluateDependsOnProject) {
        for (Project project : this.childProjects.values()) {
            this.dependsOn(project.getPath(), evaluateDependsOnProject);
        }
        return this;
    }

    public String toString() {
        if (this.parent != null) {
            return String.format("project '%s'", this.path);
        }
        return String.format("root project '%s'", this.name);
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                foundTargets.put(project, new TreeSet(project.getTasks().getAll()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return foundTargets;
    }

    @Override
    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (!GUtil.isTrue(name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return foundTasks;
    }

    @Override
    public File file(Object path) {
        return this.fileOperations.file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileOperations.file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileOperations.uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.fileOperations.files(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return this.fileOperations.files(paths, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.fileOperations.fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.fileOperations.fileTree(args);
    }

    @Override
    public ConfigurableFileTree fileTree(Closure closure) {
        return this.fileOperations.fileTree(closure);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.fileOperations.zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.fileOperations.tarTree(tarPath);
    }

    @Override
    public String relativePath(Object path) {
        return this.fileOperations.relativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        return this.fileOperations.mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.fileOperations.delete(paths);
    }

    public Directory dir(String path) {
        String[] pathElements = path.split("/");
        String name = "";
        Directory dirTask = null;
        for (String pathElement : pathElements) {
            Task task = (Task)this.taskContainer.findByName(name = name + (name.length() != 0 ? "/" + pathElement : pathElement));
            if (task instanceof Directory) {
                dirTask = (Directory)task;
                continue;
            }
            if (task != null) {
                throw new InvalidUserDataException(String.format("Cannot add directory task '%s' as a non-directory task with this name already exists.", name));
            }
            dirTask = this.taskContainer.add(name, Directory.class);
        }
        return dirTask;
    }

    public void setTaskContainer(TaskContainerInternal taskContainer) {
        this.taskContainer = taskContainer;
    }

    public Factory<? extends AntBuilder> getAntBuilderFactory() {
        return this.antBuilderFactory;
    }

    public void setAntBuilderFactory(Factory<? extends AntBuilder> antBuilderFactory) {
        this.antBuilderFactory = antBuilderFactory;
    }

    @Override
    public DependencyHandler getDependencies() {
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("beforeEvaluate", action);
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("afterEvaluate", action);
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.evaluationListener.add("beforeEvaluate", closure);
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.evaluationListener.add("afterEvaluate", closure);
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager;
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public void disableStandardOutputCapture() {
        DeprecationLogger.nagUser("Project.disableStandardOutputCapture()");
        this.loggingManager.disableStandardOutputCapture();
    }

    @Override
    public void captureStandardOutput(LogLevel level) {
        DeprecationLogger.nagUser("Project.captureStandardOutput()", "getLogging().captureStandardOutput()");
        this.loggingManager.captureStandardOutput(level);
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.dynamicObjectHelper.getProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.dynamicObjectHelper.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.dynamicObjectHelper.hasProperty(propertyName);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.dynamicObjectHelper.getProperties();
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.fileOperations.copy(closure);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.fileOperations.copySpec(closure);
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.fileOperations.javaexec(closure);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.fileOperations.exec(closure);
    }

    @Override
    public ServiceRegistryFactory getServices() {
        return this.services;
    }

    @Override
    public Module getModule() {
        return this.getServices().get(DependencyMetaDataProvider.class).getModule();
    }

    @Override
    public void apply(Closure closure) {
        DefaultObjectConfigurationAction action = new DefaultObjectConfigurationAction(this.fileResolver, this.services.get(ScriptPluginFactory.class), this);
        this.configure(action, closure);
        action.execute();
    }

    @Override
    public void apply(Map<String, ?> options) {
        DefaultObjectConfigurationAction action = new DefaultObjectConfigurationAction(this.fileResolver, this.services.get(ScriptPluginFactory.class), this);
        ConfigureUtil.configureByMap(options, action);
        action.execute();
    }

    @Override
    public AntBuilder ant(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getAnt());
    }

    @Override
    public void subprojects(Closure configureClosure) {
        this.configure(this.getSubprojects(), configureClosure);
    }

    @Override
    public void allprojects(Closure configureClosure) {
        this.configure(this.getAllprojects(), configureClosure);
    }

    @Override
    public Project project(String path, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.project(path));
    }

    @Override
    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    @Override
    public void configurations(Closure configureClosure) {
        ((Configurable)((Object)this.getConfigurations())).configure(configureClosure);
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getArtifacts());
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public Task task(String task) {
        return this.taskContainer.add(task);
    }

    public Task task(Object task) {
        return this.taskContainer.add(task.toString());
    }

    @Override
    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.add(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.add(GUtil.addMaps(options, Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.add(GUtil.addMaps(options, Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        ClassGenerator classGenerator = this.getServices().get(ClassGenerator.class);
        return classGenerator.newInstance(DefaultAutoCreateDomainObjectContainer.class, type, classGenerator);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<? extends T> factory) {
        ClassGenerator classGenerator = this.getServices().get(ClassGenerator.class);
        return classGenerator.newInstance(DefaultAutoCreateDomainObjectContainer.class, type, classGenerator, factory);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        ClassGenerator classGenerator = this.getServices().get(ClassGenerator.class);
        return classGenerator.newInstance(DefaultAutoCreateDomainObjectContainer.class, type, classGenerator, factoryClosure);
    }
}

