/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.project.ServiceRegistry;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceRegistry
implements ServiceRegistry {
    private final List<Service> services = new ArrayList<Service>();
    private final ServiceRegistry parent;
    private boolean closed;

    public DefaultServiceRegistry() {
        this(null);
    }

    public DefaultServiceRegistry(ServiceRegistry parent) {
        this.parent = parent;
        for (Class<?> type = this.getClass(); type != Object.class; type = type.getSuperclass()) {
            this.findFactoryMethods(type);
            this.findDecoratorMethods(type);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private void findFactoryMethods(Class<?> type) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.class) continue;
            this.add(new FactoryMethodService(method));
        }
    }

    private void findDecoratorMethods(Class<?> type) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 1 || method.getReturnType() == Void.class || !method.getParameterTypes()[0].equals(method.getReturnType())) continue;
            this.add(new DecoratorMethodService(method));
        }
    }

    protected void add(Service service) {
        this.services.add(0, service);
    }

    public <T> void add(Class<T> serviceType, T serviceInstance) {
        this.add(new FixedInstanceService<T>(serviceType, serviceInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            new CompositeStoppable(this.services).stop();
        }
        finally {
            this.closed = true;
            this.services.clear();
        }
    }

    @Override
    public <T> T get(Class<T> serviceType) throws IllegalArgumentException {
        block5: {
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", serviceType.getSimpleName(), this));
            }
            for (Service service : this.services) {
                T t = service.getService(serviceType);
                if (t == null) continue;
                return t;
            }
            if (this.parent != null) {
                try {
                    return this.parent.get(serviceType);
                }
                catch (UnknownServiceException e) {
                    if (e.type.equals(serviceType)) break block5;
                    throw e;
                }
            }
        }
        throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", serviceType.getSimpleName(), this));
    }

    @Override
    public <T> Factory<? extends T> getFactory(Class<T> type) {
        block5: {
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate factory for objects of type %s, as %s has been closed.", type.getSimpleName(), this));
            }
            for (Service service : this.services) {
                Factory<T> factory = service.getFactory(type);
                if (factory == null) continue;
                return factory;
            }
            if (this.parent != null) {
                try {
                    return this.parent.getFactory(type);
                }
                catch (UnknownServiceException e) {
                    if (e.type.equals(type)) break block5;
                    throw e;
                }
            }
        }
        throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", type.getSimpleName(), this));
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }

    private static Object invoke(Method method, Object target, Object ... args) {
        try {
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.asUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw UncheckedException.asUncheckedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnknownServiceException
    extends IllegalArgumentException {
        private final Class<?> type;

        UnknownServiceException(Class<?> type, String message) {
            super(message);
            this.type = type;
        }
    }

    private class DecoratorMethodService
    extends Service {
        private final Method method;

        public DecoratorMethodService(Method method) {
            super(method.getGenericReturnType());
            this.method = method;
        }

        protected Object create() {
            Object value;
            if (Factory.class.isAssignableFrom(this.method.getParameterTypes()[0])) {
                Class type;
                ParameterizedType fatoryType = (ParameterizedType)this.method.getGenericParameterTypes()[0];
                Type typeArg = fatoryType.getActualTypeArguments()[0];
                if (typeArg instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeArg;
                    type = (Class)wildcardType.getUpperBounds()[0];
                } else {
                    type = (Class)typeArg;
                }
                value = DefaultServiceRegistry.this.parent.getFactory(type);
            } else {
                value = DefaultServiceRegistry.this.parent.get(this.method.getParameterTypes()[0]);
            }
            return DefaultServiceRegistry.invoke(this.method, DefaultServiceRegistry.this, new Object[]{value});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedInstanceService<T>
    extends Service {
        private final T serviceInstance;

        public FixedInstanceService(Class<T> serviceType, T serviceInstance) {
            super(serviceType);
            this.serviceInstance = serviceInstance;
            this.getService(serviceType);
        }

        @Override
        protected Object create() {
            return this.serviceInstance;
        }
    }

    private class FactoryMethodService
    extends Service {
        private final Method method;

        public FactoryMethodService(Method method) {
            super(method.getGenericReturnType());
            this.method = method;
        }

        protected Object create() {
            return DefaultServiceRegistry.invoke(this.method, DefaultServiceRegistry.this, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Service
    implements Stoppable {
        final Type serviceType;
        final Class serviceClass;
        Object service;

        Service(Type serviceType) {
            this.serviceType = serviceType;
            this.serviceClass = this.toClass(serviceType);
        }

        public String toString() {
            return String.format("Service %s", this.serviceType);
        }

        <T> T getService(Class<T> serviceType) {
            if (!serviceType.isAssignableFrom(this.serviceClass)) {
                return null;
            }
            if (this.service == null) {
                this.service = this.create();
                assert (this.service != null);
            }
            return serviceType.cast(this.service);
        }

        protected abstract Object create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            block7: {
                try {
                    if (this.service == null) break block7;
                    try {
                        DefaultServiceRegistry.invoke(this.service.getClass().getMethod("stop", new Class[0]), this.service, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    try {
                        DefaultServiceRegistry.invoke(this.service.getClass().getMethod("close", new Class[0]), this.service, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                finally {
                    this.service = null;
                }
            }
        }

        public <T> Factory<? extends T> getFactory(Class<T> elementType) {
            if (!Factory.class.isAssignableFrom(this.serviceClass)) {
                return null;
            }
            return this.getFactory(this.serviceType, elementType);
        }

        private Factory getFactory(Type type, Class elementType) {
            ParameterizedType parameterizedType;
            Class c = this.toClass(type);
            if (!Factory.class.isAssignableFrom(c)) {
                return null;
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && parameterizedType.getActualTypeArguments()[0].equals(elementType)) {
                return this.getService(Factory.class);
            }
            for (Type interfaceType : c.getGenericInterfaces()) {
                Factory f = this.getFactory(interfaceType, elementType);
                if (f == null) continue;
                return f;
            }
            return null;
        }

        private Class toClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
    }
}

