/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction inputFileValidation = new ValidationAction(){

        public void validate(String propertyName, Object value) throws InvalidUserDataException {
            File fileValue = (File)value;
            if (!fileValue.exists()) {
                throw new InvalidUserDataException(String.format("File '%s' specified for property '%s' does not exist.", fileValue, propertyName));
            }
            if (!fileValue.isFile()) {
                throw new InvalidUserDataException(String.format("File '%s' specified for property '%s' is not a file.", fileValue, propertyName));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputFile.class;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.inputFileValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
                task.getInputs().files(futureValue);
            }
        });
    }
}

