/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DefaultNamedDomainObjectContainer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskCollection<T extends Task>
extends DefaultNamedDomainObjectContainer<T>
implements TaskCollection<T> {
    protected final ProjectInternal project;

    public DefaultTaskCollection(Class<T> type, ClassGenerator classGenerator, ProjectInternal project) {
        super(type, classGenerator);
        this.project = project;
    }

    public DefaultTaskCollection(Class<T> type, ClassGenerator classGenerator, ProjectInternal project, DefaultNamedDomainObjectContainer.NamedObjectStore<T> store) {
        super(type, classGenerator, store);
        this.project = project;
    }

    @Override
    public TaskCollection<T> matching(Spec<? super T> spec) {
        return this.getClassGenerator().newInstance(DefaultTaskCollection.class, this.getType(), this.getClassGenerator(), this.project, this.storeWithSpec(spec));
    }

    @Override
    public TaskCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec(spec));
    }

    @Override
    public <S extends T> TaskCollection<S> withType(Class<S> type) {
        return this.getClassGenerator().newInstance(DefaultTaskCollection.class, type, this.getClassGenerator(), this.project, this.storeWithType(type));
    }

    @Override
    public Action<? super T> whenTaskAdded(Action<? super T> action) {
        return this.whenObjectAdded(action);
    }

    @Override
    public void whenTaskAdded(Closure closure) {
        this.whenObjectAdded(closure);
    }

    @Override
    public void allTasks(Action<? super T> action) {
        DeprecationLogger.nagUser("TaskCollection.allTasks()", "all()");
        this.all(action);
    }

    @Override
    public void allTasks(Closure action) {
        DeprecationLogger.nagUser("TaskCollection.allTasks()", "all()");
        this.all(action);
    }

    @Override
    public String getTypeDisplayName() {
        return "task";
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownTaskException(String.format("Task with name '%s' not found in %s.", name, this.project));
    }
}

