/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;

public class DefaultTaskExecuter
implements TaskExecuter {
    private static Logger logger = Logging.getLogger(DefaultTaskExecuter.class);
    private final TaskActionListener listener;

    public DefaultTaskExecuter(TaskActionListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state) {
        this.listener.beforeActions(task);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(task.getClass().getClassLoader());
        state.setExecuting(true);
        try {
            GradleException failure = this.executeActions(task, state);
            state.executed(failure);
        }
        finally {
            state.setExecuting(false);
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this.listener.afterActions(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleException executeActions(TaskInternal task, TaskStateInternal state) {
        logger.debug("Executing actions for {}.", task);
        for (Action<? super Task> action : task.getActions()) {
            state.setDidWork(true);
            task.getStandardOutputCapture().start();
            try {
                action.execute(task);
            }
            catch (StopActionException e) {
                logger.debug("Action stopped by some action with message: {}", e.getMessage());
            }
            catch (StopExecutionException e) {
                logger.info("Execution stopped by some action with message: {}", e.getMessage());
                break;
            }
            catch (Throwable t) {
                TaskExecutionException taskExecutionException = new TaskExecutionException(task, t);
                return taskExecutionException;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
        return null;
    }
}

