/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SkipTaskExecuter
implements TaskExecuter {
    private static Logger logger = Logging.getLogger(SkipTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state) {
        logger.debug("Starting to execute {}", task);
        try {
            this.doExecute(task, state);
        }
        finally {
            state.executed();
            logger.debug("Finished executing {}", task);
        }
    }

    private void doExecute(TaskInternal task, TaskStateInternal state) {
        boolean skip;
        try {
            skip = !task.getOnlyIf().isSatisfiedBy(task);
        }
        catch (Throwable t) {
            state.executed(new GradleException(String.format("Could not evaluate onlyIf predicate for %s.", task), t));
            return;
        }
        if (skip) {
            logger.info("Skipping execution as task onlyIf is false.");
            state.skipped("SKIPPED");
            return;
        }
        this.executer.execute(task, state);
    }
}

