/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.logging;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Logging {
    public static final Marker LIFECYCLE = MarkerFactory.getDetachedMarker((String)"LIFECYCLE");
    public static final Marker QUIET = MarkerFactory.getDetachedMarker((String)"QUIET");
    public static final Map<Integer, LogLevel> ANT_IVY_2_SLF4J_LEVEL_MAPPER = new HashMap<Integer, LogLevel>(){
        {
            this.put(0, LogLevel.ERROR);
            this.put(1, LogLevel.WARN);
            this.put(2, LogLevel.INFO);
            this.put(4, LogLevel.DEBUG);
            this.put(3, LogLevel.DEBUG);
        }
    };

    public static Logger getLogger(Class c) {
        return new LoggerImpl(LoggerFactory.getLogger((Class)c));
    }

    public static Logger getLogger(String name) {
        return new LoggerImpl(LoggerFactory.getLogger((String)name));
    }

    private static class LoggerImpl
    implements Logger {
        private final org.slf4j.Logger logger;

        public LoggerImpl(org.slf4j.Logger logger) {
            this.logger = logger;
        }

        public boolean isEnabled(LogLevel level) {
            return level.isEnabled(this);
        }

        public void log(LogLevel level, String message) {
            level.log(this, message);
        }

        public void log(LogLevel level, String message, Object ... objects) {
            level.log((Logger)this, message, objects);
        }

        public void log(LogLevel level, String message, Throwable throwable) {
            level.log((Logger)this, message, throwable);
        }

        public boolean isLifecycleEnabled() {
            return this.logger.isInfoEnabled(LIFECYCLE);
        }

        public void lifecycle(String message) {
            this.logger.info(LIFECYCLE, message);
        }

        public void lifecycle(String message, Object ... objects) {
            this.logger.info(LIFECYCLE, message, objects);
        }

        public void lifecycle(String message, Throwable throwable) {
            this.logger.info(LIFECYCLE, message, throwable);
        }

        public boolean isQuietEnabled() {
            return this.logger.isInfoEnabled(QUIET);
        }

        public void quiet(String message) {
            this.logger.info(QUIET, message);
        }

        public void quiet(String message, Object ... objects) {
            this.logger.info(QUIET, message, objects);
        }

        public void quiet(String message, Throwable throwable) {
            this.logger.info(QUIET, message, throwable);
        }

        public void debug(Marker marker, String s) {
            this.logger.debug(marker, s);
        }

        public void debug(Marker marker, String s, Object o) {
            this.logger.debug(marker, s, o);
        }

        public void debug(Marker marker, String s, Object o, Object o1) {
            this.logger.debug(marker, s, o, o1);
        }

        public void debug(Marker marker, String s, Object[] objects) {
            this.logger.debug(marker, s, objects);
        }

        public void debug(Marker marker, String s, Throwable throwable) {
            this.logger.debug(marker, s, throwable);
        }

        public void debug(String s) {
            this.logger.debug(s);
        }

        public void debug(String s, Object o) {
            this.logger.debug(s, o);
        }

        public void debug(String s, Object o, Object o1) {
            this.logger.debug(s, o, o1);
        }

        public void debug(String s, Object[] objects) {
            this.logger.debug(s, objects);
        }

        public void debug(String s, Throwable throwable) {
            this.logger.debug(s, throwable);
        }

        public void error(Marker marker, String s) {
            this.logger.error(marker, s);
        }

        public void error(Marker marker, String s, Object o) {
            this.logger.error(marker, s, o);
        }

        public void error(Marker marker, String s, Object o, Object o1) {
            this.logger.error(marker, s, o, o1);
        }

        public void error(Marker marker, String s, Object[] objects) {
            this.logger.error(marker, s, objects);
        }

        public void error(Marker marker, String s, Throwable throwable) {
            this.logger.error(marker, s, throwable);
        }

        public void error(String s) {
            this.logger.error(s);
        }

        public void error(String s, Object o) {
            this.logger.error(s, o);
        }

        public void error(String s, Object o, Object o1) {
            this.logger.error(s, o, o1);
        }

        public void error(String s, Object[] objects) {
            this.logger.error(s, objects);
        }

        public void error(String s, Throwable throwable) {
            this.logger.error(s, throwable);
        }

        public String getName() {
            return this.logger.getName();
        }

        public void info(Marker marker, String s) {
            this.logger.info(marker, s);
        }

        public void info(Marker marker, String s, Object o) {
            this.logger.info(marker, s, o);
        }

        public void info(Marker marker, String s, Object o, Object o1) {
            this.logger.info(marker, s, o, o1);
        }

        public void info(Marker marker, String s, Object[] objects) {
            this.logger.info(marker, s, objects);
        }

        public void info(Marker marker, String s, Throwable throwable) {
            this.logger.info(marker, s, throwable);
        }

        public void info(String s) {
            this.logger.info(s);
        }

        public void info(String s, Object o) {
            this.logger.info(s, o);
        }

        public void info(String s, Object o, Object o1) {
            this.logger.info(s, o, o1);
        }

        public void info(String s, Object[] objects) {
            this.logger.info(s, objects);
        }

        public void info(String s, Throwable throwable) {
            this.logger.info(s, throwable);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        public void trace(Marker marker, String s) {
            this.logger.trace(marker, s);
        }

        public void trace(Marker marker, String s, Object o) {
            this.logger.trace(marker, s, o);
        }

        public void trace(Marker marker, String s, Object o, Object o1) {
            this.logger.trace(marker, s, o, o1);
        }

        public void trace(Marker marker, String s, Object[] objects) {
            this.logger.trace(marker, s, objects);
        }

        public void trace(Marker marker, String s, Throwable throwable) {
            this.logger.trace(marker, s, throwable);
        }

        public void trace(String s) {
            this.logger.trace(s);
        }

        public void trace(String s, Object o) {
            this.logger.trace(s, o);
        }

        public void trace(String s, Object o, Object o1) {
            this.logger.trace(s, o, o1);
        }

        public void trace(String s, Object[] objects) {
            this.logger.trace(s, objects);
        }

        public void trace(String s, Throwable throwable) {
            this.logger.trace(s, throwable);
        }

        public void warn(Marker marker, String s) {
            this.logger.warn(marker, s);
        }

        public void warn(Marker marker, String s, Object o) {
            this.logger.warn(marker, s, o);
        }

        public void warn(Marker marker, String s, Object o, Object o1) {
            this.logger.warn(marker, s, o, o1);
        }

        public void warn(Marker marker, String s, Object[] objects) {
            this.logger.warn(marker, s, objects);
        }

        public void warn(Marker marker, String s, Throwable throwable) {
            this.logger.warn(marker, s, throwable);
        }

        public void warn(String s) {
            this.logger.warn(s);
        }

        public void warn(String s, Object o) {
            this.logger.warn(s, o);
        }

        public void warn(String s, Object o, Object o1) {
            this.logger.warn(s, o, o1);
        }

        public void warn(String s, Object[] objects) {
            this.logger.warn(s, objects);
        }

        public void warn(String s, Throwable throwable) {
            this.logger.warn(s, throwable);
        }
    }
}

