/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.tasks.generator.Generator;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorTask<T>
extends ConventionTask {
    private File inputFile;
    private File outputFile;
    private final ActionBroadcast<T> beforeConfigured = new ActionBroadcast();
    private final ActionBroadcast<T> afterConfigured = new ActionBroadcast();
    protected Generator<T> generator;

    public GeneratorTask() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @TaskAction
    void generate() {
        File inputFile = this.getInputFile();
        T object = inputFile.exists() ? this.generator.read(inputFile) : this.generator.defaultInstance();
        this.beforeConfigured.execute(object);
        this.generator.configure(object);
        this.afterConfigured.execute(object);
        this.generator.write(object, this.getOutputFile());
    }

    public File getInputFile() {
        return this.inputFile != null ? this.inputFile : this.getOutputFile();
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void beforeConfigured(Closure closure) {
        this.beforeConfigured.add(closure);
    }

    public void beforeConfigured(Action<? super T> action) {
        this.beforeConfigured.add(action);
    }

    public void whenConfigured(Closure closure) {
        this.afterConfigured.add(closure);
    }

    public void whenConfigured(Action<? super T> action) {
        this.afterConfigured.add(action);
    }
}

