/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.GraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReportTask
extends AbstractReportTask {
    private TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    protected void generate(Project project) throws IOException {
        BuildClientMetaData metaData = this.getServices().get(BuildClientMetaData.class);
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.render(project, new GraphRenderer(textOutput), true, textOutput);
        if (project.getChildProjects().isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text("No sub-projects");
            textOutput.println();
        }
        textOutput.println();
        textOutput.text("To see a list of the tasks of a project, run ");
        metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), String.format("<project-path>:%s", "tasks"));
        textOutput.println();
        textOutput.text("For example, try running ");
        Project exampleProject = project.getChildProjects().isEmpty() ? project : this.getChildren(project).get(0);
        metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), exampleProject.absoluteProjectPath("tasks"));
        textOutput.println();
        if (project != project.getRootProject()) {
            textOutput.println();
            textOutput.text("To see a list of all the projects in this build, run ");
            metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), project.getRootProject().absoluteProjectPath("projects"));
            textOutput.println();
        }
    }

    private void render(final Project project, GraphRenderer renderer, boolean lastChild, final StyledTextOutput textOutput) {
        renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput styledTextOutput) {
                styledTextOutput.text(StringUtils.capitalize((String)project.toString()));
                if (GUtil.isTrue(project.getDescription())) {
                    textOutput.withStyle(StyledTextOutput.Style.Description).format(" - %s", project.getDescription());
                }
            }
        }, lastChild);
        renderer.startChildren();
        List<Project> children = this.getChildren(project);
        for (Project child : children) {
            this.render(child, renderer, child == children.get(children.size() - 1), textOutput);
        }
        renderer.completeChildren();
    }

    private List<Project> getChildren(Project project) {
        ArrayList<Project> children = new ArrayList<Project>(project.getChildProjects().values());
        Collections.sort(children);
        return children;
    }
}

