/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.cache.CacheFactory;
import org.gradle.cache.PersistentCache;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCloseCacheFactory
implements CacheFactory {
    private final CacheFactory cacheFactory;
    private final Map<File, CacheInfo> openCaches = new HashMap<File, CacheInfo>();

    public AutoCloseCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Override
    public PersistentCache open(File cacheDir, CacheUsage usage, Map<String, ?> properties) {
        File canonicalDir = GFileUtils.canonicalise(cacheDir);
        CacheInfo cacheInfo = this.openCaches.get(canonicalDir);
        if (cacheInfo == null) {
            PersistentCache cache = this.cacheFactory.open(cacheDir, usage, properties);
            cacheInfo = new CacheInfo(cache, properties);
            this.openCaches.put(canonicalDir, cacheInfo);
        } else if (!((Object)properties).equals(cacheInfo.properties)) {
            throw new UnsupportedOperationException(String.format("Cache '%s' is already open with different state.", cacheDir));
        }
        cacheInfo.addReference();
        return cacheInfo.cache;
    }

    @Override
    public void close(PersistentCache cache) {
        for (CacheInfo cacheInfo : this.openCaches.values()) {
            if (cacheInfo.cache != cache) continue;
            if (cacheInfo.removeReference()) {
                this.openCaches.values().remove(cacheInfo);
                this.cacheFactory.close(cacheInfo.cache);
            }
            return;
        }
        throw new IllegalArgumentException("Attempting to close unknown cache " + cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            for (CacheInfo cacheInfo : this.openCaches.values()) {
                this.cacheFactory.close(cacheInfo.cache);
            }
        }
        finally {
            this.openCaches.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheInfo {
        int count;
        final Map<String, ?> properties;
        final PersistentCache cache;

        private CacheInfo(PersistentCache cache, Map<String, ?> properties) {
            this.cache = cache;
            this.properties = new HashMap(properties);
        }

        public void addReference() {
            ++this.count;
        }

        public boolean removeReference() {
            --this.count;
            return this.count == 0;
        }
    }
}

