/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.GradleException;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStateCache<T>
implements PersistentStateCache<T> {
    private final Serializer<T> serializer;
    private final File cacheFile;
    private PersistentCache cache;

    public SimpleStateCache(PersistentCache cache, Serializer<T> serializer) {
        this.cache = cache;
        this.serializer = serializer;
        this.cacheFile = new File(cache.getBaseDir(), "state.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get() {
        if (!this.cacheFile.isFile()) {
            return null;
        }
        try {
            BufferedInputStream inStr = new BufferedInputStream(new FileInputStream(this.cacheFile));
            try {
                T t = this.serializer.read(inStr);
                return t;
            }
            finally {
                ((InputStream)inStr).close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not read cache value from '%s'.", this.cacheFile), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T newValue) {
        try {
            BufferedOutputStream outStr = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            try {
                this.serializer.write(outStr, newValue);
            }
            finally {
                ((OutputStream)outStr).close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not write cache value to '%s'.", this.cacheFile), e);
        }
        this.cache.markValid();
    }
}

