/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.btree;

import org.gradle.cache.btree.BlockPayload;
import org.gradle.cache.btree.BlockPointer;
import org.gradle.cache.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCheckBlockStore
implements BlockStore {
    private final BlockStore blockStore;
    private boolean open;

    public StateCheckBlockStore(BlockStore blockStore) {
        this.blockStore = blockStore;
    }

    @Override
    public void open(Runnable initAction, BlockStore.Factory factory) {
        assert (!this.open);
        this.open = true;
        this.blockStore.open(initAction, factory);
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.blockStore.close();
    }

    @Override
    public void clear() {
        assert (this.open);
        this.blockStore.clear();
    }

    @Override
    public void remove(BlockPayload block) {
        assert (this.open);
        this.blockStore.remove(block);
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> payloadType) {
        assert (this.open);
        return this.blockStore.readFirst(payloadType);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer pos, Class<T> payloadType) {
        assert (this.open);
        return this.blockStore.read(pos, payloadType);
    }

    @Override
    public void write(BlockPayload block) {
        assert (this.open);
        this.blockStore.write(block);
    }

    @Override
    public void attach(BlockPayload block) {
        assert (this.open);
        this.blockStore.attach(block);
    }

    @Override
    public void flush() {
        assert (this.open);
        this.blockStore.flush();
    }
}

