/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.resource.DelegatingResource;
import org.gradle.api.internal.resource.Resource;
import org.gradle.configuration.ImportsReader;
import org.gradle.groovy.scripts.DelegatingScriptSource;
import org.gradle.groovy.scripts.ScriptSource;

public class ImportsScriptSource
extends DelegatingScriptSource {
    private final ImportsReader importsReader;

    public ImportsScriptSource(ScriptSource source, ImportsReader importsReader) {
        super(source);
        this.importsReader = importsReader;
    }

    public Resource getResource() {
        return new ImportsResource(super.getResource());
    }

    private class ImportsResource
    extends DelegatingResource {
        private ImportsResource(Resource resource) {
            super(resource);
        }

        public String getText() {
            String text = this.getResource().getText();
            assert (text != null);
            String imports = text.length() > 0 ? '\n' + ImportsScriptSource.this.importsReader.getImports() : "";
            return text + imports;
        }
    }
}

