/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskGraphExecuter
implements TaskGraphExecuter {
    private static Logger logger = LoggerFactory.getLogger(DefaultTaskGraphExecuter.class);
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final Set<Task> executionPlan = new LinkedHashSet<Task>();
    private boolean populated;
    private Spec<? super Task> filter = Specs.satisfyAll();

    public DefaultTaskGraphExecuter(ListenerManager listenerManager) {
        this.graphListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionGraphListener.class);
        this.taskListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionListener.class);
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    @Override
    public void addTasks(Iterable<? extends Task> tasks) {
        assert (tasks != null);
        Clock clock = new Clock();
        TreeSet<Task> sortedTasks = new TreeSet<Task>();
        for (Task task : tasks) {
            sortedTasks.add(task);
        }
        this.fillDag(sortedTasks);
        this.populated = true;
        logger.debug("Timing: Creating the DAG took " + clock.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Clock clock = new Clock();
        this.graphListeners.getSource().graphPopulated(this);
        try {
            this.doExecute(this.executionPlan);
            logger.debug("Timing: Executing the DAG took " + clock.getTime());
        }
        finally {
            this.executionPlan.clear();
        }
    }

    @Override
    public void execute(Iterable<? extends Task> tasks) {
        this.addTasks(tasks);
        this.execute();
    }

    private void fillDag(Collection<? extends Task> tasks) {
        HashSet<Task> visiting = new HashSet<Task>();
        ArrayList<? extends Task> queue = new ArrayList<Task>();
        queue.addAll(tasks);
        CachingTaskDependencyResolveContext context = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            Task task = (Task)queue.get(0);
            if (!this.filter.isSatisfiedBy(task)) {
                queue.remove(0);
                continue;
            }
            if (this.executionPlan.contains(task)) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                TreeSet dependsOnTasks = new TreeSet(Collections.reverseOrder());
                dependsOnTasks.addAll(context.getDependencies(task));
                for (Task dependsOnTask : dependsOnTasks) {
                    if (visiting.contains(dependsOnTask)) {
                        throw new CircularReferenceException(String.format("Circular dependency between tasks. Cycle includes [%s, %s].", task, dependsOnTask));
                    }
                    queue.add(0, dependsOnTask);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            this.executionPlan.add(task);
        }
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove(listener);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add("graphPopulated", closure);
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove(listener);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.taskListeners.add("beforeExecute", closure);
    }

    @Override
    public void afterTask(Closure closure) {
        this.taskListeners.add("afterExecute", closure);
    }

    private void doExecute(Iterable<? extends Task> tasks) {
        for (Task task : tasks) {
            this.executeTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(Task task) {
        this.taskListeners.getSource().beforeExecute(task);
        try {
            ((TaskInternal)task).execute();
        }
        finally {
            this.taskListeners.getSource().afterExecute(task, task.getState());
        }
    }

    @Override
    public boolean hasTask(Task task) {
        this.assertPopulated();
        return this.executionPlan.contains(task);
    }

    @Override
    public boolean hasTask(String path) {
        this.assertPopulated();
        assert (path != null && path.length() > 0);
        for (Task task : this.getAllTasks()) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Task> getAllTasks() {
        this.assertPopulated();
        return new ArrayList<Task>(this.executionPlan);
    }

    private void assertPopulated() {
        if (!this.populated) {
            throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
        }
    }
}

