/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.GradleException;
import org.gradle.api.ScriptCompilationException;
import org.gradle.groovy.scripts.AsmBackedEmptyScriptGenerator;
import org.gradle.groovy.scripts.ScriptCompilationHandler;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.util.Clock;
import org.gradle.util.GFileUtils;
import org.gradle.util.UncheckedException;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptCompilationHandler
implements ScriptCompilationHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultScriptCompilationHandler.class);
    private static final String EMPTY_SCRIPT_MARKER_FILE_NAME = "emptyScript.txt";

    @Override
    public void compileToDir(ScriptSource source, ClassLoader classLoader, File classesDir, Transformer transformer, Class<? extends Script> scriptBaseClass) {
        Clock clock = new Clock();
        GFileUtils.deleteDirectory(classesDir);
        classesDir.mkdirs();
        CompilerConfiguration configuration = this.createBaseCompilerConfiguration(scriptBaseClass);
        configuration.setTargetDirectory(classesDir);
        try {
            this.compileScript(source, classLoader, configuration, classesDir, transformer);
        }
        catch (GradleException e) {
            GFileUtils.deleteDirectory(classesDir);
            throw e;
        }
        this.logger.debug("Timing: Writing script to cache at {} took: {}", (Object)classesDir.getAbsolutePath(), (Object)clock.getTime());
    }

    private void compileScript(final ScriptSource source, ClassLoader classLoader, CompilerConfiguration configuration, File classesDir, final Transformer transformer) {
        this.logger.info("Compiling {} using {}.", (Object)source.getDisplayName(), (Object)(transformer != null ? transformer.getClass().getSimpleName() : "no transformer"));
        final EmptyScriptDetector emptyScriptDetector = new EmptyScriptDetector();
        final PackageStatementDetector packageDetector = new PackageStatementDetector();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, configuration, false){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
                CompilationUnit compilationUnit = new CompilationUnit(compilerConfiguration, codeSource, this){

                    protected ClassVisitor createClassVisitor() {
                        return new ClassWriter(1){

                            public void visitSource(String sourcePath, String debugInfo) {
                                super.visitSource(source.getFileName(), debugInfo);
                            }
                        };
                    }
                };
                if (transformer != null) {
                    transformer.register(compilationUnit);
                }
                compilationUnit.addPhaseOperation((CompilationUnit.SourceUnitOperation)packageDetector, 5);
                compilationUnit.addPhaseOperation((CompilationUnit.SourceUnitOperation)emptyScriptDetector, 5);
                return compilationUnit;
            }
        };
        String scriptText = source.getResource().getText();
        String scriptName = source.getClassName();
        GroovyCodeSource codeSource = new GroovyCodeSource(scriptText == null ? "" : scriptText, scriptName, "/groovy/script");
        try {
            groovyClassLoader.parseClass(codeSource, false);
        }
        catch (MultipleCompilationErrorsException e) {
            this.wrapCompilationFailure(source, e);
        }
        catch (CompilationFailedException e) {
            throw new GradleException(String.format("Could not compile %s.", source.getDisplayName()), e);
        }
        if (packageDetector.hasPackageStatement) {
            throw new UnsupportedOperationException(String.format("%s should not contain a package statement.", StringUtils.capitalize((String)source.getDisplayName())));
        }
        if (emptyScriptDetector.isEmptyScript()) {
            GFileUtils.touch(new File(classesDir, EMPTY_SCRIPT_MARKER_FILE_NAME));
        }
    }

    private void wrapCompilationFailure(ScriptSource source, MultipleCompilationErrorsException e) {
        for (Object message : e.getErrorCollector().getErrors()) {
            if (!(message instanceof SyntaxErrorMessage)) continue;
            try {
                SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)message;
                Field sourceField = SyntaxErrorMessage.class.getDeclaredField("source");
                sourceField.setAccessible(true);
                SourceUnit sourceUnit = (SourceUnit)sourceField.get(syntaxErrorMessage);
                Field nameField = SourceUnit.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(sourceUnit, source.getDisplayName());
            }
            catch (Exception failure) {
                throw UncheckedException.asUncheckedException(failure);
            }
        }
        SyntaxException syntaxError = e.getErrorCollector().getSyntaxError(0);
        Integer lineNumber = syntaxError == null ? null : Integer.valueOf(syntaxError.getLine());
        throw new ScriptCompilationException(String.format("Could not compile %s.", source.getDisplayName()), (Throwable)e, source, lineNumber);
    }

    private CompilerConfiguration createBaseCompilerConfiguration(Class<? extends Script> scriptBaseClass) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setScriptBaseClass(scriptBaseClass.getName());
        return configuration;
    }

    @Override
    public <T extends Script> Class<? extends T> loadFromDir(ScriptSource source, ClassLoader classLoader, File scriptCacheDir, Class<T> scriptBaseClass) {
        if (new File(scriptCacheDir, EMPTY_SCRIPT_MARKER_FILE_NAME).isFile()) {
            return new AsmBackedEmptyScriptGenerator().generate(scriptBaseClass);
        }
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(WrapUtil.toArray(scriptCacheDir.toURI().toURL()), classLoader);
            return urlClassLoader.loadClass(source.getClassName()).asSubclass(scriptBaseClass);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not load compiled classes for %s from cache.", source.getDisplayName()), e);
        }
    }

    private static class EmptyScriptDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean emptyScript;

        private EmptyScriptDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.emptyScript = this.isEmpty(source);
        }

        private boolean isEmpty(SourceUnit source) {
            ConstantExpression constantExpression;
            ReturnStatement returnStatement;
            if (!source.getAST().getMethods().isEmpty()) {
                return false;
            }
            List statements = source.getAST().getStatementBlock().getStatements();
            if (statements.size() > 1) {
                return false;
            }
            if (statements.isEmpty()) {
                return true;
            }
            Statement statement = (Statement)statements.get(0);
            return statement instanceof ReturnStatement && (returnStatement = (ReturnStatement)statement).getExpression() instanceof ConstantExpression && (constantExpression = (ConstantExpression)returnStatement.getExpression()).getValue() == null;
        }

        public boolean isEmptyScript() {
            return this.emptyScript;
        }
    }

    private static class PackageStatementDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean hasPackageStatement;

        private PackageStatementDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.hasPackageStatement = source.getAST().getPackageName() != null;
        }
    }
}

