/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import java.io.File;
import java.util.HashMap;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.groovy.scripts.CachingScriptSource;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptCompilationHandler;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptRunnerFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.util.HashUtil;
import org.gradle.util.ReflectionUtil;

public class DefaultScriptCompilerFactory
implements ScriptCompilerFactory {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final CacheRepository cacheRepository;
    private final ScriptRunnerFactory scriptRunnerFactory;

    public DefaultScriptCompilerFactory(ScriptCompilationHandler scriptCompilationHandler, ScriptRunnerFactory scriptRunnerFactory, CacheRepository cacheRepository) {
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.cacheRepository = cacheRepository;
        this.scriptRunnerFactory = scriptRunnerFactory;
    }

    public ScriptCompiler createCompiler(ScriptSource source) {
        return new ScriptCompilerImpl(source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptCompilerImpl
    implements ScriptCompiler {
        private final ScriptSource source;
        private ClassLoader classloader;
        private Transformer transformer;

        public ScriptCompilerImpl(ScriptSource source) {
            this.source = new CachingScriptSource(source);
        }

        @Override
        public ScriptCompiler setClassloader(ClassLoader classloader) {
            this.classloader = classloader;
            return this;
        }

        @Override
        public ScriptCompiler setTransformer(Transformer transformer) {
            this.transformer = transformer;
            return this;
        }

        @Override
        public <T extends Script> ScriptRunner<T> compile(Class<T> scriptType) {
            ClassLoader classloader = this.classloader != null ? this.classloader : Thread.currentThread().getContextClassLoader();
            T script = this.loadViaCache(classloader, scriptType);
            ((Script)((Object)script)).setScriptSource(this.source);
            ((Script)((Object)script)).setContextClassloader(classloader);
            return DefaultScriptCompilerFactory.this.scriptRunnerFactory.create(script);
        }

        private <T extends Script> T loadViaCache(ClassLoader classLoader, Class<T> scriptBaseClass) {
            File classesDir;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("source.filename", this.source.getFileName());
            properties.put("source.hash", HashUtil.createHash(this.source.getResource().getText()));
            PersistentCache cache = DefaultScriptCompilerFactory.this.cacheRepository.cache(String.format("scripts/%s", this.source.getClassName())).withProperties(properties).open();
            if (this.transformer != null) {
                String subdirName = String.format("%s_%s", this.transformer.getId(), scriptBaseClass.getSimpleName());
                classesDir = new File(cache.getBaseDir(), subdirName);
            } else {
                classesDir = new File(cache.getBaseDir(), scriptBaseClass.getSimpleName());
            }
            if (!cache.isValid() || !classesDir.exists()) {
                DefaultScriptCompilerFactory.this.scriptCompilationHandler.compileToDir(this.source, classLoader, classesDir, this.transformer, scriptBaseClass);
                cache.markValid();
            }
            Class<T> scriptClass = DefaultScriptCompilerFactory.this.scriptCompilationHandler.loadFromDir(this.source, classLoader, classesDir, scriptBaseClass);
            return (T)((Object)((Script)((Object)scriptBaseClass.cast(ReflectionUtil.newInstance(scriptClass, new Object[0])))));
        }
    }
}

