/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.ProjectSpec;
import org.gradle.util.Clock;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildLoader.class);
    private final IProjectFactory projectFactory;

    public BuildLoader(IProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
    }

    public void load(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle, Map<String, String> externalProjectProperties) {
        LOGGER.debug("Loading Project objects");
        Clock clock = new Clock();
        this.createProjects(rootProjectDescriptor, gradle, externalProjectProperties);
        this.attachDefaultProject(gradle);
        LOGGER.debug("Timing: Loading projects took: " + clock.getTime());
    }

    private void attachDefaultProject(GradleInternal gradle) {
        ProjectInternal defaultProject;
        ProjectSpec selector = gradle.getStartParameter().getDefaultProjectSelector();
        try {
            defaultProject = selector.selectProject(gradle.getRootProject().getProjectRegistry());
        }
        catch (InvalidUserDataException e) {
            throw new GradleException(String.format("Could not select the default project for this build. %s", e.getMessage()), e);
        }
        gradle.setDefaultProject(defaultProject);
    }

    private void createProjects(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle, Map<String, String> externalProjectProperties) {
        ProjectInternal rootProject = this.projectFactory.createProject(rootProjectDescriptor, null, gradle);
        gradle.setRootProject(rootProject);
        this.addPropertiesToProject(externalProjectProperties, rootProject);
        this.addProjects(rootProject, rootProjectDescriptor, gradle, externalProjectProperties);
    }

    private void addProjects(ProjectInternal parent, ProjectDescriptor parentProjectDescriptor, GradleInternal gradle, Map<String, String> externalProjectProperties) {
        for (ProjectDescriptor childProjectDescriptor : parentProjectDescriptor.getChildren()) {
            ProjectInternal childProject = this.projectFactory.createProject(childProjectDescriptor, parent, gradle);
            this.addPropertiesToProject(externalProjectProperties, childProject);
            this.addProjects(childProject, childProjectDescriptor, gradle, externalProjectProperties);
        }
    }

    private void addPropertiesToProject(Map<String, String> externalProperties, ProjectInternal project) {
        Properties projectProperties = new Properties();
        File projectPropertiesFile = new File(project.getProjectDir(), "gradle.properties");
        LOGGER.debug("Looking for project properties from: {}", (Object)projectPropertiesFile);
        if (projectPropertiesFile.isFile()) {
            projectProperties = GUtil.loadProperties(projectPropertiesFile);
            LOGGER.debug("Adding project properties (if not overwritten by user properties): {}", projectProperties.keySet());
        } else {
            LOGGER.debug("project property file does not exists. We continue!");
        }
        projectProperties.putAll(externalProperties);
        for (Object key : projectProperties.keySet()) {
            project.setProperty((String)key, projectProperties.get(key));
        }
    }
}

