/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.GradleScriptException;
import org.gradle.api.LocationAwareException;
import org.gradle.api.ScriptCompilationException;
import org.gradle.api.internal.Contextual;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.ExceptionDecoratingClassGenerator;
import org.gradle.listener.ListenerManager;

public class DefaultExceptionAnalyser
implements ExceptionAnalyser,
ScriptExecutionListener {
    private final Map<String, ScriptSource> scripts = new HashMap<String, ScriptSource>();
    private final ExceptionDecoratingClassGenerator generator = new ExceptionDecoratingClassGenerator();

    public DefaultExceptionAnalyser(ListenerManager listenerManager) {
        listenerManager.addListener(this);
    }

    public void beforeScript(Script script) {
        ScriptSource source = script.getScriptSource();
        this.scripts.put(source.getFileName(), source);
    }

    public void afterScript(Script script, Throwable result) {
    }

    public Throwable transform(Throwable exception) {
        Throwable actualException = this.findDeepest(exception);
        if (actualException == null) {
            return exception;
        }
        if (actualException instanceof LocationAwareException) {
            return actualException;
        }
        ScriptSource source = null;
        Integer lineNumber = null;
        if (actualException instanceof ScriptCompilationException) {
            ScriptCompilationException scriptCompilationException = (ScriptCompilationException)actualException;
            source = scriptCompilationException.getScriptSource();
            lineNumber = scriptCompilationException.getLineNumber();
        }
        if (source == null) {
            block0: for (Throwable currentException = actualException; currentException != null; currentException = currentException.getCause()) {
                for (StackTraceElement element : currentException.getStackTrace()) {
                    if (!this.scripts.containsKey(element.getFileName())) continue;
                    source = this.scripts.get(element.getFileName());
                    lineNumber = element.getLineNumber() >= 0 ? Integer.valueOf(element.getLineNumber()) : null;
                    continue block0;
                }
            }
        }
        if (source == null && actualException instanceof TaskExecutionException) {
            TaskExecutionException taskExecutionException = (TaskExecutionException)actualException;
            source = ((ProjectInternal)taskExecutionException.getTask().getProject()).getBuildScriptSource();
        }
        return (Throwable)this.generator.newInstance(actualException.getClass(), actualException, source, lineNumber);
    }

    private Throwable findDeepest(Throwable exception) {
        Throwable result = null;
        Throwable contextMatch = null;
        for (Throwable current = exception; current != null; current = current.getCause()) {
            if (current instanceof GradleScriptException || current instanceof TaskExecutionException) {
                result = current;
            }
            if (current.getClass().getAnnotation(Contextual.class) == null) continue;
            contextMatch = current;
        }
        return result != null ? result : contextMatch;
    }
}

