/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.GradleLauncher;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.SettingsHandler;
import org.gradle.logging.LoggingManagerInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGradleLauncher
extends GradleLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGradleLauncher.class);
    private final GradleInternal gradle;
    private final SettingsHandler settingsHandler;
    private final IGradlePropertiesLoader gradlePropertiesLoader;
    private final BuildLoader buildLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final InitScriptHandler initScriptHandler;
    private final LoggingManagerInternal loggingManager;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsHandler settingsHandler, IGradlePropertiesLoader gradlePropertiesLoader, BuildLoader buildLoader, BuildConfigurer buildConfigurer, BuildListener buildListener, ExceptionAnalyser exceptionAnalyser, LoggingManagerInternal loggingManager) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsHandler = settingsHandler;
        this.gradlePropertiesLoader = gradlePropertiesLoader;
        this.buildLoader = buildLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.loggingManager = loggingManager;
    }

    public BuildResult run() {
        return this.doBuild(Stage.Build);
    }

    public BuildResult getBuildAnalysis() {
        return this.doBuild(Stage.Configure);
    }

    public BuildResult getBuildAndRunAnalysis() {
        return this.doBuild(Stage.PopulateTaskGraph);
    }

    private BuildResult doBuild(Stage upTo) {
        this.loggingManager.start();
        this.buildListener.buildStarted(this.gradle);
        Throwable failure = null;
        try {
            this.doBuildStages(upTo);
        }
        catch (Throwable t) {
            failure = this.exceptionAnalyser.transform(t);
        }
        BuildResult buildResult = new BuildResult(this.gradle, failure);
        this.buildListener.buildFinished(buildResult);
        this.loggingManager.stop();
        return buildResult;
    }

    private void doBuildStages(Stage upTo) {
        this.initScriptHandler.executeScripts(this.gradle);
        SettingsInternal settings = this.settingsHandler.findAndLoadSettings(this.gradle, this.gradlePropertiesLoader);
        this.buildListener.settingsEvaluated(settings);
        this.buildLoader.load(settings.getRootProject(), this.gradle, this.gradlePropertiesLoader.getGradleProperties());
        this.buildListener.projectsLoaded(this.gradle);
        this.buildConfigurer.configure(this.gradle);
        this.buildListener.projectsEvaluated(this.gradle);
        if (upTo == Stage.Configure) {
            return;
        }
        BuildExecuter executer = this.gradle.getStartParameter().getBuildExecuter();
        executer.select(this.gradle);
        if (upTo == Stage.PopulateTaskGraph) {
            return;
        }
        LOGGER.info(String.format("Starting build for %s.", executer.getDisplayName()));
        executer.execute();
        assert (upTo == Stage.Build);
    }

    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    public void useLogger(Object logger) {
        this.gradle.useLogger(logger);
    }

    public void addStandardOutputListener(StandardOutputListener listener) {
        this.loggingManager.addStandardOutputListener(listener);
    }

    public void addStandardErrorListener(StandardOutputListener listener) {
        this.loggingManager.addStandardErrorListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Configure,
        PopulateTaskGraph,
        Build;

    }
}

