/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Arrays;
import org.gradle.BuildAdapter;
import org.gradle.BuildLogger;
import org.gradle.BuildResult;
import org.gradle.GradleLauncher;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionLogger;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.project.GlobalServicesRegistry;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ServiceRegistry;
import org.gradle.api.internal.project.TopLevelBuildServiceRegistry;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.cache.CacheRepository;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.BuildProgressLogger;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.BuildSourceBuilder;
import org.gradle.initialization.ClassLoaderFactory;
import org.gradle.initialization.CommandLineConverter;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.DefaultGradlePropertiesLoader;
import org.gradle.initialization.DefaultSettingsFinder;
import org.gradle.initialization.EmbeddedScriptSettingsFinder;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.MasterDirSettingsFinderStrategy;
import org.gradle.initialization.NestedBuildTracker;
import org.gradle.initialization.ParentDirSettingsFinderStrategy;
import org.gradle.initialization.SettingsHandler;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.invocation.DefaultGradle;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.profile.ProfileListener;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final ServiceRegistry sharedServices;
    private final NestedBuildTracker tracker;
    private CommandLineConverter<StartParameter> commandLineConverter;

    public DefaultGradleLauncherFactory(ServiceRegistry loggingServices) {
        this(new GlobalServicesRegistry(loggingServices));
    }

    public DefaultGradleLauncherFactory() {
        this(new GlobalServicesRegistry());
    }

    private DefaultGradleLauncherFactory(GlobalServicesRegistry globalServices) {
        this.sharedServices = globalServices;
        this.commandLineConverter = this.sharedServices.get(CommandLineConverter.class);
        this.tracker = new NestedBuildTracker();
        ListenerManager listenerManager = this.sharedServices.get(ListenerManager.class);
        listenerManager.addListener(new BuildProgressLogger(this.sharedServices.get(ProgressLoggerFactory.class)));
        GradleLauncher.injectCustomFactory(this);
    }

    public void addListener(Object listener) {
        this.sharedServices.get(ListenerManager.class).addListener(listener);
    }

    public void removeListener(Object listener) {
        this.sharedServices.get(ListenerManager.class).removeListener(listener);
    }

    @Override
    public StartParameter createStartParameter(String ... commandLineArgs) {
        return this.commandLineConverter.convert(Arrays.asList(commandLineArgs));
    }

    @Override
    public DefaultGradleLauncher newInstance(StartParameter startParameter) {
        DefaultBuildRequestMetaData requestMetaData = this.tracker.getCurrentBuild() != null ? new DefaultBuildRequestMetaData(this.tracker.getCurrentBuild().getServices().get(BuildClientMetaData.class), System.currentTimeMillis()) : new DefaultBuildRequestMetaData(System.currentTimeMillis());
        return this.doNewInstance(startParameter, requestMetaData);
    }

    @Override
    public DefaultGradleLauncher newInstance(StartParameter startParameter, BuildRequestMetaData requestMetaData) {
        assert (this.tracker.getCurrentBuild() == null);
        return this.doNewInstance(startParameter, requestMetaData);
    }

    private DefaultGradleLauncher doNewInstance(StartParameter startParameter, BuildRequestMetaData requestMetaData) {
        TopLevelBuildServiceRegistry serviceRegistry = new TopLevelBuildServiceRegistry(this.sharedServices, startParameter);
        serviceRegistry.add(BuildRequestMetaData.class, requestMetaData);
        serviceRegistry.add(BuildClientMetaData.class, requestMetaData.getClient());
        ListenerManager listenerManager = serviceRegistry.get(ListenerManager.class);
        LoggingManagerInternal loggingManager = serviceRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.setLevel(startParameter.getLogLevel());
        loggingManager.colorStdOutAndStdErr(startParameter.isColorOutput());
        loggingManager.addStandardOutputListener(listenerManager.getBroadcaster(StandardOutputListener.class));
        loggingManager.addStandardErrorListener(listenerManager.getBroadcaster(StandardOutputListener.class));
        listenerManager.useLogger(new TaskExecutionLogger(serviceRegistry.get(ProgressLoggerFactory.class)));
        if (this.tracker.getCurrentBuild() == null) {
            listenerManager.useLogger(new BuildLogger(Logging.getLogger(BuildLogger.class), serviceRegistry.get(StyledTextOutputFactory.class), startParameter, requestMetaData));
        }
        listenerManager.addListener(this.tracker);
        listenerManager.addListener(new BuildCleanupListener(serviceRegistry));
        if (startParameter.isProfile()) {
            listenerManager.addListener(new ProfileListener(requestMetaData.getBuildTimeClock().getStartTime()));
        }
        DefaultGradle gradle = new DefaultGradle(this.tracker.getCurrentBuild(), startParameter, serviceRegistry);
        return new DefaultGradleLauncher(gradle, serviceRegistry.get(InitScriptHandler.class), new SettingsHandler(new EmbeddedScriptSettingsFinder(new DefaultSettingsFinder(WrapUtil.toList(new MasterDirSettingsFinderStrategy(), new ParentDirSettingsFinderStrategy()))), serviceRegistry.get(SettingsProcessor.class), new BuildSourceBuilder(this, serviceRegistry.get(ClassLoaderFactory.class), serviceRegistry.get(CacheRepository.class))), new DefaultGradlePropertiesLoader(), new BuildLoader(serviceRegistry.get(IProjectFactory.class)), serviceRegistry.get(BuildConfigurer.class), gradle.getBuildListenerBroadcaster(), serviceRegistry.get(ExceptionAnalyser.class), loggingManager);
    }

    public void setCommandLineConverter(CommandLineConverter<StartParameter> commandLineConverter) {
        this.commandLineConverter = commandLineConverter;
    }

    private static class BuildCleanupListener
    extends BuildAdapter {
        private final TopLevelBuildServiceRegistry services;

        private BuildCleanupListener(TopLevelBuildServiceRegistry services) {
            this.services = services;
        }

        public void buildFinished(BuildResult result) {
            this.services.close();
        }
    }
}

