/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.StartParameter;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger(DefaultGradlePropertiesLoader.class);
    private Map<String, String> gradleProperties = new HashMap<String, String>();

    @Override
    public void loadProperties(File settingsDir, StartParameter startParameter) {
        this.loadProperties(settingsDir, startParameter, this.getAllSystemProperties(), this.getAllEnvProperties());
    }

    void loadProperties(File settingsDir, StartParameter startParameter, Map<String, String> systemProperties, Map<String, String> envProperties) {
        this.gradleProperties.clear();
        this.addGradleProperties(new File(settingsDir, "gradle.properties"), new File(startParameter.getGradleUserHomeDir(), "gradle.properties"));
        this.setSystemProperties(startParameter.getSystemPropertiesArgs());
        this.gradleProperties.putAll(this.getEnvProjectProperties(envProperties));
        this.gradleProperties.putAll(this.getSystemProjectProperties(systemProperties));
        this.gradleProperties.putAll(startParameter.getProjectProperties());
    }

    Map getAllSystemProperties() {
        return System.getProperties();
    }

    Map<String, String> getAllEnvProperties() {
        try {
            return System.getenv();
        }
        catch (Throwable e) {
            logger.debug("The System.getenv() call has lead to an exception. Probably you are running on Java 1.4.", e);
            return Collections.emptyMap();
        }
    }

    private void addGradleProperties(File ... files) {
        for (File propertyFile : files) {
            if (!propertyFile.isFile()) continue;
            Properties properties = GUtil.loadProperties(propertyFile);
            this.gradleProperties.putAll(new HashMap<Object, Object>(properties));
        }
    }

    @Override
    public Map<String, String> getGradleProperties() {
        return this.gradleProperties;
    }

    public void setGradleProperties(Map<String, String> gradleProperties) {
        this.gradleProperties = gradleProperties;
    }

    private Map<String, String> getSystemProjectProperties(Map<String, String> systemProperties) {
        HashMap<String, String> systemProjectProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            if (!entry.getKey().startsWith("org.gradle.project.") || entry.getKey().length() <= "org.gradle.project.".length()) continue;
            systemProjectProperties.put(entry.getKey().substring("org.gradle.project.".length()), entry.getValue());
        }
        logger.debug("Found system project properties: {}", systemProjectProperties.keySet());
        return systemProjectProperties;
    }

    private Map<String, String> getEnvProjectProperties(Map<String, String> envProperties) {
        HashMap<String, String> envProjectProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : envProperties.entrySet()) {
            if (!entry.getKey().startsWith("ORG_GRADLE_PROJECT_") || entry.getKey().length() <= "ORG_GRADLE_PROJECT_".length()) continue;
            envProjectProperties.put(entry.getKey().substring("ORG_GRADLE_PROJECT_".length()), entry.getValue());
        }
        logger.debug("Found env project properties: {}", envProjectProperties.keySet());
        return envProjectProperties;
    }

    private void setSystemProperties(Map<String, String> properties) {
        System.getProperties().putAll(properties);
        this.addSystemPropertiesFromGradleProperties();
    }

    private void addSystemPropertiesFromGradleProperties() {
        for (String key : this.gradleProperties.keySet()) {
            if (!key.startsWith("systemProp.")) continue;
            System.setProperty(key.substring("systemProp.".length()), this.gradleProperties.get(key));
        }
    }
}

