/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.LocationAwareException;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.Contextual;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.ReflectionUtil;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDecoratingClassGenerator
implements ClassGenerator {
    private static final Map<Class<?>, Class<?>> GENERATED_CLASSES = new HashMap();

    @Override
    public <T> T newInstance(Class<T> type, Object ... parameters) {
        Throwable throwable = (Throwable)ReflectionUtil.newInstance(this.generate(type), parameters);
        throwable.setStackTrace(((Throwable)parameters[0]).getStackTrace());
        return type.cast(throwable);
    }

    @Override
    public <T> Class<? extends T> generate(Class<T> type) {
        Class<Object> generated = GENERATED_CLASSES.get(type);
        if (generated == null) {
            generated = this.doGenerate(type);
            GENERATED_CLASSES.put(type, generated);
        }
        return generated;
    }

    private <T> Class<? extends T> doGenerate(Class<T> type) {
        boolean noArgsConstructor;
        ClassWriter visitor = new ClassWriter(1);
        String typeName = StringUtils.substringBeforeLast((String)type.getName(), (String)".") + ".LocationAware" + type.getSimpleName();
        Type generatedType = Type.getType((String)("L" + typeName.replaceAll("\\.", "/") + ";"));
        Type superclassType = Type.getType(type);
        visitor.visit(49, 1, generatedType.getInternalName(), null, superclassType.getInternalName(), new String[]{Type.getType(LocationAwareException.class).getInternalName()});
        Type helperType = Type.getType(ExceptionHelper.class);
        Type throwableType = Type.getType(Throwable.class);
        Type scriptSourceType = Type.getType(ScriptSource.class);
        Type integerType = Type.getType(Integer.class);
        visitor.visitField(2, "helper", helperType.getDescriptor(), null, null);
        String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{superclassType, scriptSourceType, integerType});
        MethodVisitor methodVisitor = visitor.visitMethod(1, "<init>", methodDescriptor, null, new String[0]);
        methodVisitor.visitCode();
        try {
            type.getConstructor(type);
            noArgsConstructor = false;
        }
        catch (NoSuchMethodException e) {
            try {
                type.getConstructor(new Class[0]);
                noArgsConstructor = true;
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException(String.format("Cannot create subtype for exception '%s'. It needs a zero-args or copy constructor.", type.getName()));
            }
        }
        if (noArgsConstructor) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, superclassType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        } else {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(183, superclassType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{superclassType}));
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitTypeInsn(187, helperType.getInternalName());
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(183, helperType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{throwableType, throwableType, scriptSourceType, integerType}));
        methodVisitor.visitFieldInsn(181, generatedType.getInternalName(), "helper", helperType.getDescriptor());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        for (Method method : ExceptionHelper.class.getDeclaredMethods()) {
            methodDescriptor = Type.getMethodDescriptor((Type)Type.getType(method.getReturnType()), (Type[])new Type[0]);
            methodVisitor = visitor.visitMethod(1, method.getName(), methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, generatedType.getInternalName(), "helper", helperType.getDescriptor());
            methodVisitor.visitMethodInsn(182, helperType.getInternalName(), method.getName(), methodDescriptor);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        visitor.visitEnd();
        byte[] bytecode = visitor.toByteArray();
        return (Class)ReflectionUtil.invoke(type.getClassLoader(), "defineClass", typeName, bytecode, 0, bytecode.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExceptionHelper {
        private final Throwable target;
        private final ScriptSource source;
        private final Integer lineNumber;

        public ExceptionHelper(Throwable owner, Throwable target, ScriptSource source, Integer lineNumber) {
            if (owner.getCause() == null) {
                owner.initCause(target.getCause());
            }
            this.target = target;
            this.source = source;
            this.lineNumber = lineNumber;
        }

        public String getOriginalMessage() {
            return this.target.getMessage();
        }

        public Throwable getOriginalException() {
            return this.target;
        }

        public String getLocation() {
            if (this.source == null) {
                return null;
            }
            String sourceMsg = StringUtils.capitalize((String)this.source.getDisplayName());
            if (this.lineNumber == null) {
                return sourceMsg;
            }
            return String.format("%s line: %d", sourceMsg, this.lineNumber);
        }

        public String getMessage() {
            String location = this.getLocation();
            String message = this.target.getMessage();
            if (location == null && message == null) {
                return null;
            }
            if (location == null) {
                return message;
            }
            if (message == null) {
                return location;
            }
            return String.format("%s%n%s", location, message);
        }

        public ScriptSource getScriptSource() {
            return this.source;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public List<Throwable> getReportableCauses() {
            ArrayList<Throwable> causes = new ArrayList<Throwable>();
            for (Throwable t = this.target.getCause(); t != null; t = t.getCause()) {
                causes.add(t);
                if (t.getClass().getAnnotation(Contextual.class) == null) break;
            }
            return causes;
        }
    }
}

