/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.net.URLClassLoader;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.SettingsFactory;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsScript;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatingSettingsProcessor
implements SettingsProcessor {
    private static Logger logger = LoggerFactory.getLogger(ScriptEvaluatingSettingsProcessor.class);
    private SettingsFactory settingsFactory;
    private ScriptPluginFactory configurerFactory;

    public ScriptEvaluatingSettingsProcessor(ScriptPluginFactory configurerFactory, SettingsFactory settingsFactory) {
        this.configurerFactory = configurerFactory;
        this.settingsFactory = settingsFactory;
    }

    public SettingsInternal process(GradleInternal gradle, SettingsLocation settingsLocation, URLClassLoader buildSourceClassLoader, StartParameter startParameter, IGradlePropertiesLoader propertiesLoader) {
        Clock settingsProcessingClock = new Clock();
        SettingsInternal settings = this.settingsFactory.createSettings(gradle, settingsLocation.getSettingsDir(), settingsLocation.getSettingsScriptSource(), propertiesLoader.getGradleProperties(), startParameter, buildSourceClassLoader);
        this.applySettingsScript(settingsLocation, buildSourceClassLoader, settings);
        logger.debug("Timing: Processing settings took: {}", (Object)settingsProcessingClock.getTime());
        return settings;
    }

    private void applySettingsScript(SettingsLocation settingsLocation, ClassLoader buildSourceClassLoader, SettingsInternal settings) {
        ScriptPlugin configurer = this.configurerFactory.create(settingsLocation.getSettingsScriptSource());
        configurer.setClassLoader(buildSourceClassLoader);
        configurer.setScriptBaseClass(SettingsScript.class);
        configurer.apply(settings);
    }
}

