/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.LinkedList;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.Label;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;

public class ConsoleBackedProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final Console console;
    private final LinkedList<String> operations = new LinkedList();
    private Label statusBar;

    public ConsoleBackedProgressRenderer(OutputEventListener listener, Console console) {
        this.listener = listener;
        this.console = console;
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.operations.addLast("");
        } else if (event instanceof ProgressCompleteEvent) {
            this.operations.removeLast();
            this.updateText();
        } else if (event instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)event;
            this.operations.removeLast();
            this.operations.addLast(progressEvent.getStatus());
            this.updateText();
        }
        this.listener.onOutput(event);
    }

    private void updateText() {
        StringBuilder builder = new StringBuilder();
        for (String operation : this.operations) {
            if (operation.length() == 0) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("> ");
            builder.append(operation);
        }
        if (this.statusBar == null) {
            this.statusBar = this.console.getStatusBar();
        }
        this.statusBar.setText(builder.toString());
    }
}

