/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.jansi.Ansi;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.ColorMap;

public class DefaultColorMap
implements ColorMap {
    private static final String STATUSBAR = "statusbar";
    private static final String BOLD = "bold";
    private final Map<String, String> defaults = new HashMap<String, String>();
    private final Map<String, ColorMap.Color> colors = new HashMap<String, ColorMap.Color>();
    private boolean useColor = true;
    private final ColorMap.Color noDecoration = new ColorMap.Color(){

        public void on(Ansi ansi) {
        }

        public void off(Ansi ansi) {
        }
    };

    public DefaultColorMap() {
        this.addDefault(StyledTextOutput.Style.Info, "yellow");
        this.addDefault(StyledTextOutput.Style.Error, "default");
        this.addDefault(StyledTextOutput.Style.Header, "default");
        this.addDefault(StyledTextOutput.Style.Description, "yellow");
        this.addDefault(StyledTextOutput.Style.ProgressStatus, "yellow");
        this.addDefault(StyledTextOutput.Style.Identifier, "green");
        this.addDefault(StyledTextOutput.Style.UserInput, BOLD);
        this.addDefault(StyledTextOutput.Style.Success, "default");
        this.addDefault(StyledTextOutput.Style.Failure, "red");
        this.addDefault(STATUSBAR, BOLD);
    }

    private void addDefault(StyledTextOutput.Style style, String color) {
        this.addDefault(style.name().toLowerCase(), color);
    }

    private void addDefault(String style, String color) {
        this.defaults.put(style, color);
    }

    public void setUseColor(boolean useColor) {
        this.useColor = useColor;
    }

    public ColorMap.Color getStatusBarColor() {
        return this.getColor(STATUSBAR);
    }

    public ColorMap.Color getColourFor(StyledTextOutput.Style style) {
        return this.getColor(style.name().toLowerCase());
    }

    private ColorMap.Color getColor(String style) {
        if (!this.useColor) {
            return this.noDecoration;
        }
        ColorMap.Color color = this.colors.get(style);
        if (color == null) {
            color = this.createColor(style);
            this.colors.put(style, color);
        }
        return color;
    }

    private ColorMap.Color createColor(String style) {
        String colorSpec = System.getProperty(String.format("org.gradle.color.%s", style), this.defaults.get(style));
        if (colorSpec != null) {
            if (colorSpec.equalsIgnoreCase(BOLD)) {
                String terminalProgram = System.getenv("TERM_PROGRAM");
                if (terminalProgram != null && terminalProgram.equals("iTerm.app")) {
                    return this.noDecoration;
                }
                return new AttributeColor(Ansi.Attribute.INTENSITY_BOLD, Ansi.Attribute.INTENSITY_BOLD_OFF);
            }
            if (colorSpec.equalsIgnoreCase("reverse")) {
                return new AttributeColor(Ansi.Attribute.NEGATIVE_ON, Ansi.Attribute.NEGATIVE_OFF);
            }
            if (colorSpec.equalsIgnoreCase("italic")) {
                return new AttributeColor(Ansi.Attribute.ITALIC, Ansi.Attribute.ITALIC_OFF);
            }
            Ansi.Color ansiColor = Ansi.Color.valueOf((String)colorSpec.toUpperCase());
            if (ansiColor != Ansi.Color.DEFAULT) {
                return new ForegroundColor(ansiColor);
            }
        }
        return this.noDecoration;
    }

    private static class AttributeColor
    implements ColorMap.Color {
        private final Ansi.Attribute on;
        private final Ansi.Attribute off;

        public AttributeColor(Ansi.Attribute on, Ansi.Attribute off) {
            this.on = on;
            this.off = off;
        }

        public void on(Ansi ansi) {
            ansi.a(this.on);
        }

        public void off(Ansi ansi) {
            ansi.a(this.off);
        }
    }

    private static class ForegroundColor
    implements ColorMap.Color {
        private final Ansi.Color ansiColor;

        public ForegroundColor(Ansi.Color ansiColor) {
            this.ansiColor = ansiColor;
        }

        public void on(Ansi ansi) {
            ansi.fg(this.ansiColor);
        }

        public void off(Ansi ansi) {
            ansi.fg(Ansi.Color.DEFAULT);
        }
    }
}

