/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.io.PrintStream;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logging;
import org.gradle.logging.internal.LogEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.MarkerFilter;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.util.UncheckedException;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slf4jLoggingConfigurer
implements LoggingConfigurer {
    private final Appender appender;
    private LogLevel currentLevel;
    private final PrintStream defaultStdOut = System.out;

    public Slf4jLoggingConfigurer(OutputEventListener outputListener) {
        this.appender = new Appender(outputListener);
    }

    @Override
    public void configure(LogLevel logLevel) {
        if (this.currentLevel == logLevel) {
            return;
        }
        try {
            this.doConfigure(logLevel);
        }
        catch (Throwable e) {
            this.doFailsafeConfiguration();
            throw UncheckedException.asUncheckedException(e);
        }
    }

    private void doFailsafeConfiguration() {
        final LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>(){
            {
                this.setContext((Context)lc);
                this.setTarget("System.err");
                this.setLayout((Layout)new PatternLayout(){
                    {
                        this.setPattern("%msg%n%ex");
                        this.setContext((Context)lc);
                        this.start();
                    }
                });
                this.start();
            }
        };
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.setLevel(Level.INFO);
        rootLogger.addAppender((ch.qos.logback.core.Appender)consoleAppender);
    }

    private void doConfigure(LogLevel logLevel) {
        Logger rootLogger;
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (this.currentLevel == null) {
            lc.reset();
            this.appender.setContext((Context)lc);
            rootLogger = lc.getLogger("ROOT");
            rootLogger.addAppender((ch.qos.logback.core.Appender)this.appender);
        } else {
            rootLogger = lc.getLogger("ROOT");
        }
        this.currentLevel = logLevel;
        this.appender.stop();
        this.appender.clearAllFilters();
        switch (logLevel) {
            case DEBUG: {
                rootLogger.setLevel(Level.DEBUG);
                break;
            }
            case INFO: {
                rootLogger.setLevel(Level.INFO);
                break;
            }
            case LIFECYCLE: {
                this.appender.addFilter(new MarkerFilter(Logging.QUIET, Logging.LIFECYCLE));
                this.appender.addFilter(this.createLevelFilter(lc, Level.INFO, FilterReply.DENY, FilterReply.NEUTRAL));
                rootLogger.setLevel(Level.INFO);
                break;
            }
            case QUIET: {
                this.appender.addFilter(new MarkerFilter(Logging.QUIET));
                this.appender.addFilter(this.createLevelFilter(lc, Level.INFO, FilterReply.DENY, FilterReply.NEUTRAL));
                rootLogger.setLevel(Level.INFO);
                break;
            }
            case WARN: {
                rootLogger.setLevel(Level.WARN);
                break;
            }
            case ERROR: {
                rootLogger.setLevel(Level.ERROR);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.appender.start();
    }

    private Filter<ILoggingEvent> createLevelFilter(LoggerContext lc, Level level, FilterReply onMatch, FilterReply onMismatch) {
        LevelFilter levelFilter = new LevelFilter();
        levelFilter.setContext((Context)lc);
        levelFilter.setOnMatch(onMatch);
        levelFilter.setOnMismatch(onMismatch);
        levelFilter.setLevel(level);
        levelFilter.start();
        return levelFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Appender
    extends AppenderBase<ILoggingEvent> {
        private final OutputEventListener listener;

        private Appender(OutputEventListener listener) {
            this.listener = listener;
        }

        protected void append(ILoggingEvent event) {
            try {
                ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
                Throwable throwable = throwableProxy == null ? null : throwableProxy.getThrowable();
                String message = event.getFormattedMessage();
                this.listener.onOutput(new LogEvent(event.getTimeStamp(), event.getLoggerName(), this.toLogLevel(event), message, throwable));
            }
            catch (Throwable t) {
                t.printStackTrace(Slf4jLoggingConfigurer.this.defaultStdOut);
            }
        }

        private LogLevel toLogLevel(ILoggingEvent event) {
            switch (event.getLevel().toInt()) {
                case 10000: {
                    return LogLevel.DEBUG;
                }
                case 20000: {
                    if (event.getMarker() == Logging.LIFECYCLE) {
                        return LogLevel.LIFECYCLE;
                    }
                    if (event.getMarker() == Logging.QUIET) {
                        return LogLevel.QUIET;
                    }
                    return LogLevel.INFO;
                }
                case 30000: {
                    return LogLevel.WARN;
                }
                case 40000: {
                    return LogLevel.ERROR;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot map SLF4j Level %s to a LogLevel", event.getLevel()));
        }
    }
}

